
use crate::models::DateTime; 

#[derive(Debug, Clone, serde::Serialize, serde::Deserialize, Default)]
pub struct SecureTokenView {
    
    #[serde(rename = "Expires", skip_serializing_if = "Option::is_none")]
    pub expires: Option<DateTime>,
    
    #[serde(rename = "Value", skip_serializing_if = "Option::is_none")]
    pub value: Option<String>,
    
}