
use crate::models::ContractInvoiceActionSubView; 
use crate::models::DebtCollectionActionSubView; 
use crate::models::InstallmentPlanActionSubView; 
use crate::models::InvoiceActionSubView; 
use crate::models::ReconciliationInvoiceActionSubView; 
use crate::models::SelfInvoiceActionSubView; 
use crate::models::SupplierInvoiceActionSubView; 

#[derive(Debug, Clone, serde::Serialize, serde::Deserialize, Default)]
pub struct SearchResultView {
    
    #[serde(rename = "ContractInvoiceActions", skip_serializing_if = "Vec::is_empty", default)]
    pub contract_invoice_actions: Vec<ContractInvoiceActionSubView>,
    
    #[serde(rename = "DebtCollectionActions", skip_serializing_if = "Vec::is_empty", default)]
    pub debt_collection_actions: Vec<DebtCollectionActionSubView>,
    
    #[serde(rename = "InstallmentPlanActions", skip_serializing_if = "Vec::is_empty", default)]
    pub installment_plan_actions: Vec<InstallmentPlanActionSubView>,
    
    #[serde(rename = "InvoiceActions", skip_serializing_if = "Vec::is_empty", default)]
    pub invoice_actions: Vec<InvoiceActionSubView>,
    
    #[serde(rename = "ReconciliationInvoiceActions", skip_serializing_if = "Vec::is_empty", default)]
    pub reconciliation_invoice_actions: Vec<ReconciliationInvoiceActionSubView>,
    
    #[serde(rename = "SelfInvoiceActions", skip_serializing_if = "Vec::is_empty", default)]
    pub self_invoice_actions: Vec<SelfInvoiceActionSubView>,
    
    #[serde(rename = "SupplierInvoiceActions", skip_serializing_if = "Vec::is_empty", default)]
    pub supplier_invoice_actions: Vec<SupplierInvoiceActionSubView>,
    
}