
use crate::models::Base64; 
use crate::models::Guid; 

#[derive(Debug, Clone, serde::Serialize, serde::Deserialize, Default)]
pub struct FileView {
    
    #[serde(rename = "ContentType", skip_serializing_if = "Option::is_none")]
    pub content_type: Option<String>,
    
    #[serde(rename = "Data", skip_serializing_if = "Option::is_none")]
    pub data: Option<Base64>,
    
    #[serde(rename = "FileName", skip_serializing_if = "Option::is_none")]
    pub file_name: Option<String>,
    
    #[serde(rename = "FilePublicId", skip_serializing_if = "Option::is_none")]
    pub file_public_id: Option<Guid>,
    
}