
use crate::models::DateTime; 
use crate::models::Guid; 

#[derive(Debug, Clone, serde::Serialize, serde::Deserialize, Default)]
pub struct DebtorCreditCardView {
    
    #[serde(rename = "Brand", skip_serializing_if = "Option::is_none")]
    pub brand: Option<String>,
    
    #[serde(rename = "Created", skip_serializing_if = "Option::is_none")]
    pub created: Option<DateTime>,
    
    #[serde(rename = "CreditCardPublicId", skip_serializing_if = "Option::is_none")]
    pub credit_card_public_id: Option<Guid>,
    
    #[serde(rename = "Expires", skip_serializing_if = "Option::is_none")]
    pub expires: Option<DateTime>,
    
    #[serde(rename = "MaskedCardNumber", skip_serializing_if = "Option::is_none")]
    pub masked_card_number: Option<String>,
    
}