use std::fmt;


#[derive(Debug, Clone, Copy, serde::Serialize, serde::Deserialize, PartialEq, Eq)]
#[serde(rename_all = "PascalCase")]
#[allow(non_camel_case_types)]
pub enum DebtCollectionActionStageTypeView {
    
    Attested,
    AwaitingFeePayment,
    Cancelled,
    Completed,
    Created,
    DebtCollectionClaimDue,
    DebtCollectionClaimResponseRequested,
    DebtCollectionInvoiceSent,
    EnforcementResponseRequested,
    ForeignCreditorLetterSent,
    ForeignDebtorLetterSent,
    ForeignMakeReadyForLocalRepresentative,
    ForeignManual,
    ForeignSentToLocalRepresentative,
    LatePaymentInvoiceSent,
    LongTermSurveilance,
    Manual,
    None,
    ReadyForAttest,
    ReadyForBailiff,
    ReadyForEnforcement,
    ReminderInvoiceSent,
    SentToBailiff,
    SentToBailiffEnforcement,
    VerdictObtained,

}


impl fmt::Display for DebtCollectionActionStageTypeView {


    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(f, "{:?}", self)
    }
    
}