
use crate::models::CreditorPaymentMethodPriorityTypeView; 
use crate::models::CreditorPaymentMethodTypeView; 

#[derive(Debug, Clone, serde::Serialize, serde::Deserialize, Default)]
pub struct CreditorPaymentMethodView {
    
    #[serde(rename = "AccountNo", skip_serializing_if = "Option::is_none")]
    pub account_no: Option<String>,
    
    #[serde(rename = "BIC", skip_serializing_if = "Option::is_none")]
    pub bic: Option<String>,
    
    #[serde(rename = "BankgiroNo", skip_serializing_if = "Option::is_none")]
    pub bankgiro_no: Option<String>,
    
    #[serde(rename = "ClearingNo", skip_serializing_if = "Option::is_none")]
    pub clearing_no: Option<String>,
    
    #[serde(rename = "IBAN", skip_serializing_if = "Option::is_none")]
    pub iban: Option<String>,
    
    #[serde(rename = "PaymentMethod", skip_serializing_if = "Option::is_none")]
    pub payment_method: Option<CreditorPaymentMethodTypeView>,
    
    #[serde(rename = "PlusgiroNo", skip_serializing_if = "Option::is_none")]
    pub plusgiro_no: Option<String>,
    
    #[serde(rename = "Priority", skip_serializing_if = "Option::is_none")]
    pub priority: Option<CreditorPaymentMethodPriorityTypeView>,
    
    #[serde(rename = "Verified", skip_serializing_if = "Option::is_none")]
    pub verified: Option<bool>,
    
}