
use crate::models::CommentTargetTypeView; 
use crate::models::FileView; 

#[derive(Debug, Clone, serde::Serialize, serde::Deserialize, Default)]
pub struct CommentActionView {
    
    #[serde(rename = "ActionPublicId", skip_serializing_if = "Option::is_none")]
    pub action_public_id: Option<String>,
    
    #[serde(rename = "Attachment", skip_serializing_if = "Option::is_none")]
    pub attachment: Option<FileView>,
    
    #[serde(rename = "Comment", skip_serializing_if = "Option::is_none")]
    pub comment: Option<String>,
    
    #[serde(rename = "Target", skip_serializing_if = "Option::is_none")]
    pub target: Option<CommentTargetTypeView>,
    
}