use std::fmt;


#[derive(Debug, Clone, Copy, serde::Serialize, serde::Deserialize, PartialEq, Eq)]
#[serde(rename_all = "PascalCase")]
#[allow(non_camel_case_types)]
pub enum ActionTypeView {
    
    ContractInvoiceAction,
    CreditInvoiceAction,
    DebentureAction,
    DebtCollectionAction,
    InstallmentPlanAction,
    InterestInvoiceAction,
    InvoiceAction,
    OrderAction,
    OrderInvoiceAction,
    PaymentAdviceAction,
    ReconciliationInvoiceAction,
    SelfInvoiceAction,
    SupplierInvoiceAction,
    VerificationInvoiceAction,

}


impl fmt::Display for ActionTypeView {


    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(f, "{:?}", self)
    }
    
}