use std::fmt;


#[derive(Debug, Clone, Copy, serde::Serialize, serde::Deserialize, PartialEq, Eq)]
#[serde(rename_all = "PascalCase")]
#[allow(non_camel_case_types)]
pub enum AccountingSettingsAccountTypeView {
    
    AccountPayablesAccount,
    AccrualAccount,
    AdministrationCostAccount,
    CurrencyDifferenceGainsAccount,
    CurrencyDifferenceLossesAccount,
    CustomerAdvancedPaymentsAccount,
    FinancialCostsAccount,
    FinancialInstituteDebtAccount,
    FreightCostAccount,
    IncomingVATAccount,
    InterestAccount,
    OtherOperatingIncomeAccount,
    RestingVATAccount,
    RevenueCorrectionAccount,
    RoundingAccount,
    SalesWithReverseVATAccount,
    SalesWithRotRutAccount,
    ShortTermDebtsAccount,
    TradeDebtsAccount,
    TradeDebtsTaxReductionAccount,
    UnmatchedPaymentsAccount,
    VATAccount,
    WriteOffAccount,

}


impl fmt::Display for AccountingSettingsAccountTypeView {


    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(f, "{:?}", self)
    }
    
}