use crate::{Param, PathAndQueryBuilder, Result};
use eiktyrner::{content, HttpClient};

use crate::models::{FileView, Guid};
use crate::Client;

impl Client {
    ///
    /// - **id**: File public id
    /// - **includedata**: Include the file data stream in the request
    pub async fn files_get_a_file_metadata(
        &self,
        id: Guid,
        includedata: Option<bool>,
    ) -> Result<FileView> {
        let path_and_query = PathAndQueryBuilder::default()
            .url(Param::value("v1"))
            .url(Param::value("files"))
            .url(Param::value("fileobject"))
            .url(Param::value(id))
            .query("includedata", Param::opt(includedata))
            .build();

        let request = self
            .new_request(http::method::Method::GET, path_and_query)
            .body(content::Empty)
            .expect("setting json body");

        self.client.send::<_, content::Json<_>>(request).await
    }

    ///
    /// - **id**: File public id
    pub async fn files_get_file_content_stream(&self, id: Guid) -> Result<Vec<u8>> {
        let path_and_query = PathAndQueryBuilder::default()
            .url(Param::value("v1"))
            .url(Param::value("files"))
            .url(Param::value("file"))
            .url(Param::value(id))
            .build();

        let request = self
            .new_request(http::method::Method::GET, path_and_query)
            .body(content::Empty)
            .expect("setting json body");

        self.client.send::<_, content::Bytes>(request).await
    }
}