use eiktyrner::{content, HttpClient};
use crate::{Param, PathAndQueryBuilder, Result};

use crate::Client;
use crate::models::{
     CreatedView,
     CreditCardAddIntentView,
     CreditCardAddView,
     DebtorAutogiroApprovalsView,
     DebtorEventsView,
     DebtorView,
     DebtorsView,
     Guid,
    
};


impl Client {
    
    

/// Removes all personal information about the customer and inactivates it
/// - **id**: Debtor public id
pub async fn debtors_anonymize_debtor_gdpr(&self,id: Guid,
                         
) -> Result<()> {


    let path_and_query = PathAndQueryBuilder::default()
        .url(Param::value("v1"))
        .url(Param::value("debtors"))
        .url(Param::value("anonymize"))
        .url(Param::value(id))
        .build();






    let request = self.new_request(
        http::method::Method::PUT,
        path_and_query,
    )
    
    .body(content::Empty).expect("setting json body");
    
    
    self.client.send::<_, content::Empty>(request).await
    
}
    
    

/// Get all existing debtor autogiro approval XML's
/// - **id**: Debtor public id
pub async fn debtors_autogiro_approval_xml(&self,id: Guid,
                         
) -> Result<DebtorAutogiroApprovalsView> {


    let path_and_query = PathAndQueryBuilder::default()
        .url(Param::value("v1"))
        .url(Param::value("debtors"))
        .url(Param::value("autogiroapprovalxmls"))
        .url(Param::value(id))
        .build();






    let request = self.new_request(
        http::method::Method::GET,
        path_and_query,
    )
    
    .body(content::Empty).expect("setting json body");
    
    self.client.send::<_, content::Json<_>>(request).await
    
}
    
    

/// Creates a debtor. Note that DebtorPublicId are generated by Billecta API and can't be set through the API and should be omitted when creating. CreditorPublicId specifies under which creditor it shall be created since creditors don't share data
pub async fn debtors_create_a_debtor(&self,body: DebtorView,
                         
) -> Result<CreatedView> {


    let path_and_query = PathAndQueryBuilder::default()
        .url(Param::value("v1"))
        .url(Param::value("debtors"))
        .url(Param::value("debtor"))
        .build();






    let request = self.new_request(
        http::method::Method::POST,
        path_and_query,
    )
    .body(content::Json(body)).expect("setting json body");
    
    self.client.send::<_, content::Json<_>>(request).await
    
}
    
    

/// Creates an intent to add a credit card on debtor. Endpoints following all PCI requirements. No card number is handled directly by your site. Create the request and load the AddWindowUrl in an iframe. Once the addition is complete the iframe will be redirected to the SuccessUrl/FailedUrl (on you site)
pub async fn debtors_create_an_intent_to_add_credit_card_on_debtor(&self,body: CreditCardAddIntentView,
                         
) -> Result<CreditCardAddView> {


    let path_and_query = PathAndQueryBuilder::default()
        .url(Param::value("v1"))
        .url(Param::value("debtors"))
        .url(Param::value("addcreditcard"))
        .build();






    let request = self.new_request(
        http::method::Method::POST,
        path_and_query,
    )
    .body(content::Json(body)).expect("setting json body");
    
    self.client.send::<_, content::Json<_>>(request).await
    
}
    
    

/// Imports multiple debtors. If debtor has DebtorPublicId set it will update corresponding debtor. If DebtorPublicId is not set the debtor will be created
pub async fn debtors_create_update_multiple_debtors(&self,body: DebtorsView,
                         
) -> Result<()> {


    let path_and_query = PathAndQueryBuilder::default()
        .url(Param::value("v1"))
        .url(Param::value("debtors"))
        .url(Param::value("debtors"))
        .build();






    let request = self.new_request(
        http::method::Method::POST,
        path_and_query,
    )
    .body(content::Json(body)).expect("setting json body");
    
    
    self.client.send::<_, content::Empty>(request).await
    
}
    
    

/// A debtor can't be deleted if it used in an invoice (of any kind)
/// - **id**: Debtor public id
pub async fn debtors_delete_a_debtor(&self,id: Guid,
                         
) -> Result<()> {


    let path_and_query = PathAndQueryBuilder::default()
        .url(Param::value("v1"))
        .url(Param::value("debtors"))
        .url(Param::value("debtor"))
        .url(Param::value(id))
        .build();






    let request = self.new_request(
        http::method::Method::DELETE,
        path_and_query,
    )
    
    .body(content::Empty).expect("setting json body");
    
    
    self.client.send::<_, content::Empty>(request).await
    
}
    
    

/// 
/// - **id**: Debtor credit card public id
pub async fn debtors_delete_a_saved_credit_card_on_debtor(&self,id: Guid,
                         
) -> Result<()> {


    let path_and_query = PathAndQueryBuilder::default()
        .url(Param::value("v1"))
        .url(Param::value("debtors"))
        .url(Param::value("addcreditcard"))
        .url(Param::value(id))
        .build();






    let request = self.new_request(
        http::method::Method::DELETE,
        path_and_query,
    )
    
    .body(content::Empty).expect("setting json body");
    
    
    self.client.send::<_, content::Empty>(request).await
    
}
    
    

/// Get the 'Add credit card' intent to view status
/// - **id**: Debtor public id
pub async fn debtors_get_add_credit_card_intent(&self,id: Guid,
                         
) -> Result<CreditCardAddView> {


    let path_and_query = PathAndQueryBuilder::default()
        .url(Param::value("v1"))
        .url(Param::value("debtors"))
        .url(Param::value("addcreditcard"))
        .url(Param::value(id))
        .build();






    let request = self.new_request(
        http::method::Method::GET,
        path_and_query,
    )
    
    .body(content::Empty).expect("setting json body");
    
    self.client.send::<_, content::Json<_>>(request).await
    
}
    
    

/// Get a single debtor by its DebtorPublicId.
/// - **id**: Debtor public id
pub async fn debtors_get_a_debtor(&self,id: Guid,
                         
) -> Result<DebtorView> {


    let path_and_query = PathAndQueryBuilder::default()
        .url(Param::value("v1"))
        .url(Param::value("debtors"))
        .url(Param::value("debtor"))
        .url(Param::value(id))
        .build();






    let request = self.new_request(
        http::method::Method::GET,
        path_and_query,
    )
    
    .body(content::Empty).expect("setting json body");
    
    self.client.send::<_, content::Json<_>>(request).await
    
}
    
    

/// Get all debtors for a creditor
/// - **id**: Creditor public id
/// - **offset**: Offset
/// - **limit**: Limit
/// - **sortingfield**: Sorting field
/// - **asc**: Ascending sorting. Default value is true
pub async fn debtors_get_all_debtors(&self,id: Guid,
                         offset: Option<i64>,
                         limit: Option<i64>,
                         sortingfield: Option<String>,
                         asc: Option<bool>,
                         
) -> Result<DebtorsView> {


    let path_and_query = PathAndQueryBuilder::default()
        .url(Param::value("v1"))
        .url(Param::value("debtors"))
        .url(Param::value("debtors"))
        .url(Param::value(id))
        .query("offset", Param::opt(offset))
        .query("limit", Param::opt(limit))
        .query("sortingfield", Param::opt(sortingfield))
        .query("asc", Param::opt(asc))
        .build();






    let request = self.new_request(
        http::method::Method::GET,
        path_and_query,
    )
    
    .body(content::Empty).expect("setting json body");
    
    self.client.send::<_, content::Json<_>>(request).await
    
}
    
    

/// Get a single debtor by its debtor number. Debtor number is unique per creditor
/// - **id**: Creditor public id
/// - **debtorno**: Debtor number
pub async fn debtors_get_debtor_by_debtor_number(&self,id: Guid,
                         debtorno: String,
                         
) -> Result<DebtorView> {


    let path_and_query = PathAndQueryBuilder::default()
        .url(Param::value("v1"))
        .url(Param::value("debtors"))
        .url(Param::value("debtorbydebtorno"))
        .url(Param::value(id))
        .query("debtorno", Param::value(debtorno))
        .build();






    let request = self.new_request(
        http::method::Method::GET,
        path_and_query,
    )
    
    .body(content::Empty).expect("setting json body");
    
    self.client.send::<_, content::Json<_>>(request).await
    
}
    
    

/// Gets all debtor events for the specified debtor.
/// - **id**: Debtor public id
pub async fn debtors_get_debtor_events(&self,id: Guid,
                         
) -> Result<DebtorEventsView> {


    let path_and_query = PathAndQueryBuilder::default()
        .url(Param::value("v1"))
        .url(Param::value("debtors"))
        .url(Param::value("debtorevents"))
        .url(Param::value(id))
        .build();






    let request = self.new_request(
        http::method::Method::GET,
        path_and_query,
    )
    
    .body(content::Empty).expect("setting json body");
    
    self.client.send::<_, content::Json<_>>(request).await
    
}
    
    

/// Get all debtors by its external id. External id is text field where you can set to any value. It could be your internal id of the customer
/// - **id**: Creditor public id
/// - **externalid**: Debtor external id
/// - **offset**: Offset
/// - **limit**: Limit
/// - **sortingfield**: Sorting field
/// - **asc**: Ascending sorting. Default value is true
pub async fn debtors_get_debtors_by_debtor_external_id(&self,id: Guid,
                         externalid: String,
                         offset: Option<i64>,
                         limit: Option<i64>,
                         sortingfield: Option<String>,
                         asc: Option<bool>,
                         
) -> Result<DebtorsView> {


    let path_and_query = PathAndQueryBuilder::default()
        .url(Param::value("v1"))
        .url(Param::value("debtors"))
        .url(Param::value("debtorsbyexternalid"))
        .url(Param::value(id))
        .query("externalid", Param::value(externalid))
        .query("offset", Param::opt(offset))
        .query("limit", Param::opt(limit))
        .query("sortingfield", Param::opt(sortingfield))
        .query("asc", Param::opt(asc))
        .build();






    let request = self.new_request(
        http::method::Method::GET,
        path_and_query,
    )
    
    .body(content::Empty).expect("setting json body");
    
    self.client.send::<_, content::Json<_>>(request).await
    
}
    
    

/// Get all debtors by person or organizational number. Country code of the format of the organisational number must be specified.
/// - **id**: Creditor public id
/// - **orgno**: Debtor organisation number
/// - **countrycode**: Country code for organisation number
/// - **offset**: Offset
/// - **limit**: Limit
/// - **sortingfield**: Sorting field
/// - **asc**: Ascending sorting. Default value is true
pub async fn debtors_get_debtors_by_person_organisation_number(&self,id: Guid,
                         orgno: String,
                         countrycode: String,
                         offset: Option<i64>,
                         limit: Option<i64>,
                         sortingfield: Option<String>,
                         asc: Option<bool>,
                         
) -> Result<DebtorsView> {


    let path_and_query = PathAndQueryBuilder::default()
        .url(Param::value("v1"))
        .url(Param::value("debtors"))
        .url(Param::value("debtorsbyorgno"))
        .url(Param::value(id))
        .query("orgno", Param::value(orgno))
        .query("countrycode", Param::value(countrycode))
        .query("offset", Param::opt(offset))
        .query("limit", Param::opt(limit))
        .query("sortingfield", Param::opt(sortingfield))
        .query("asc", Param::opt(asc))
        .build();






    let request = self.new_request(
        http::method::Method::GET,
        path_and_query,
    )
    
    .body(content::Empty).expect("setting json body");
    
    self.client.send::<_, content::Json<_>>(request).await
    
}
    
    

/// Note that DebtorPublicId must be set when updating a debtor. It is used to identify which debtor to update. CreditorPublicId specifies under which creditor it shall be created since creditors don't share data
pub async fn debtors_update_a_debtor(&self,body: DebtorView,
                         
) -> Result<()> {


    let path_and_query = PathAndQueryBuilder::default()
        .url(Param::value("v1"))
        .url(Param::value("debtors"))
        .url(Param::value("debtor"))
        .build();






    let request = self.new_request(
        http::method::Method::PUT,
        path_and_query,
    )
    .body(content::Json(body)).expect("setting json body");
    
    
    self.client.send::<_, content::Empty>(request).await
    
}
    
}