use eiktyrner::{content, HttpClient};
use crate::{Param, PathAndQueryBuilder, Result};

use crate::Client;
use crate::models::{
     CommentActionView,
     CommonActionEventsView,
     CreatedView,
     CreditActionView,
     DateTime,
     DebtCollectionActionSubsView,
     DebtCollectionActionView,
     DebtCollectionEntryView,
     DebtCollectionFromInvoiceEntryView,
     DebtCollectionFromReconciliationInvoiceEntryView,
     Guid,
     UpdateAddressActionView,
    
};


impl Client {
    
    

/// Cancels a debt collection action and disconnects any Billecta invoice
/// - **id**: Debt collection action public id
pub async fn debt_collection_cancel_a_debt_collection_action(&self,id: String,
                         
) -> Result<()> {


    let path_and_query = PathAndQueryBuilder::default()
        .url(Param::value("v1"))
        .url(Param::value("debtcollection"))
        .url(Param::value("cancel"))
        .url(Param::value(id))
        .build();






    let request = self.new_request(
        http::method::Method::PUT,
        path_and_query,
    )
    
    .body(content::Empty).expect("setting json body");
    
    
    self.client.send::<_, content::Empty>(request).await
    
}
    
    

/// 
pub async fn debt_collection_comment_a_debt_collection_action(&self,body: CommentActionView,
                         
) -> Result<()> {


    let path_and_query = PathAndQueryBuilder::default()
        .url(Param::value("v1"))
        .url(Param::value("debtcollection"))
        .url(Param::value("comment"))
        .build();






    let request = self.new_request(
        http::method::Method::POST,
        path_and_query,
    )
    .body(content::Json(body)).expect("setting json body");
    
    
    self.client.send::<_, content::Empty>(request).await
    
}
    
    

/// Decoupled debt collection actions are actions that are not a result of an invoice created in Billecta and instead created in an external system. You must in a decoupled debt collection action send the invoice PDF and amounts in the POST call. This feature requires that the creditor has been reviewed and approved by Billecta customer service before active.
pub async fn debt_collection_create_a_decoupled_new_debt_collection_action(&self,body: DebtCollectionEntryView,
                         
) -> Result<()> {


    let path_and_query = PathAndQueryBuilder::default()
        .url(Param::value("v1"))
        .url(Param::value("debtcollection"))
        .url(Param::value("action"))
        .build();






    let request = self.new_request(
        http::method::Method::POST,
        path_and_query,
    )
    .body(content::Json(body)).expect("setting json body");
    
    
    self.client.send::<_, content::Empty>(request).await
    
}
    
    

/// Create a new debt collection action from a reconciliation invoice. Payments on the reconciliation invoice will affect the debt collection and vice versa and make both always in sync with remaining amounts
pub async fn debt_collection_create_new_debt_collection_action_from_a_reconciliation_invoice(&self,body: DebtCollectionFromReconciliationInvoiceEntryView,
                         
) -> Result<CreatedView> {


    let path_and_query = PathAndQueryBuilder::default()
        .url(Param::value("v1"))
        .url(Param::value("debtcollection"))
        .url(Param::value("actionfromreconciliationinvoice"))
        .build();






    let request = self.new_request(
        http::method::Method::POST,
        path_and_query,
    )
    .body(content::Json(body)).expect("setting json body");
    
    self.client.send::<_, content::Json<_>>(request).await
    
}
    
    

/// Create a new debt collection action from an invoice that was created in Billecta. Payments on the invoice will affect the debt collection and vice versa and make both always in sync with remaining amounts.
pub async fn debt_collection_create_new_debt_collection_action_from_an_invoice(&self,body: DebtCollectionFromInvoiceEntryView,
                         
) -> Result<CreatedView> {


    let path_and_query = PathAndQueryBuilder::default()
        .url(Param::value("v1"))
        .url(Param::value("debtcollection"))
        .url(Param::value("actionfrominvoice"))
        .build();






    let request = self.new_request(
        http::method::Method::POST,
        path_and_query,
    )
    .body(content::Json(body)).expect("setting json body");
    
    self.client.send::<_, content::Json<_>>(request).await
    
}
    
    

/// Create a new debt collection action from an invoice that was created in Billecta. Payments on the invoice will affect the debt collection and vice versa and make both always in sync with remaining amounts. This endpoint uses the values in the default configuration
/// - **id**: Invoice action public id
pub async fn debt_collection_create_new_debt_collection_action_from_an_invoice_using_default_settings(&self,id: String,
                         
) -> Result<CreatedView> {


    let path_and_query = PathAndQueryBuilder::default()
        .url(Param::value("v1"))
        .url(Param::value("debtcollection"))
        .url(Param::value("actionfrominvoice"))
        .url(Param::value(id))
        .build();






    let request = self.new_request(
        http::method::Method::POST,
        path_and_query,
    )
    
    .body(content::Empty).expect("setting json body");
    
    self.client.send::<_, content::Json<_>>(request).await
    
}
    
    

/// Credit/Lower the current amount on the specified debt collection action. If amount is a actual payment the InvoiceInterest property indicates if interest up to payment date should be added to next claim if any. If debt collection action is fully paid, then flag is ignored.
pub async fn debt_collection_credit_lower_the_debt_on_a_debt_collection_action(&self,body: CreditActionView,
                         
) -> Result<CreatedView> {


    let path_and_query = PathAndQueryBuilder::default()
        .url(Param::value("v1"))
        .url(Param::value("debtcollection"))
        .url(Param::value("credit"))
        .build();






    let request = self.new_request(
        http::method::Method::POST,
        path_and_query,
    )
    .body(content::Json(body)).expect("setting json body");
    
    self.client.send::<_, content::Json<_>>(request).await
    
}
    
    

/// Delete the overridden debtor address and uses the address from the debtor card
/// - **id**: Debt collecion action public id
pub async fn debt_collection_delete_address_override_for_action(&self,id: String,
                         body: UpdateAddressActionView,
                         
) -> Result<()> {


    let path_and_query = PathAndQueryBuilder::default()
        .url(Param::value("v1"))
        .url(Param::value("debtcollection"))
        .url(Param::value("address"))
        .url(Param::value(id))
        .build();






    let request = self.new_request(
        http::method::Method::DELETE,
        path_and_query,
    )
    .body(content::Json(body)).expect("setting json body");
    
    
    self.client.send::<_, content::Empty>(request).await
    
}
    
    

/// Dispute a debt collection action. Billecta is prohibited from regulations to move claim forward.
/// - **id**: Debt collection action public id
pub async fn debt_collection_dispute_debt_collection_action(&self,id: String,
                         
) -> Result<()> {


    let path_and_query = PathAndQueryBuilder::default()
        .url(Param::value("v1"))
        .url(Param::value("debtcollection"))
        .url(Param::value("dispute"))
        .url(Param::value(id))
        .build();






    let request = self.new_request(
        http::method::Method::PUT,
        path_and_query,
    )
    
    .body(content::Empty).expect("setting json body");
    
    
    self.client.send::<_, content::Empty>(request).await
    
}
    
    

/// 
/// - **id**: Debt collecion action public id
pub async fn debt_collection_get_a_debt_collection_action(&self,id: String,
                         
) -> Result<DebtCollectionActionView> {


    let path_and_query = PathAndQueryBuilder::default()
        .url(Param::value("v1"))
        .url(Param::value("debtcollection"))
        .url(Param::value("action"))
        .url(Param::value(id))
        .build();






    let request = self.new_request(
        http::method::Method::GET,
        path_and_query,
    )
    
    .body(content::Empty).expect("setting json body");
    
    self.client.send::<_, content::Json<_>>(request).await
    
}
    
    

/// Get all debt collection actions that was closed/fully paid on the specified date interval
/// - **id**: Debt collection action public id
/// - **from**: From date
/// - **to**: To date
/// - **offset**: Offset
/// - **limit**: Limit
/// - **sortingfield**: Sorting field
/// - **asc**: Ascending sorting. Default value is true
pub async fn debt_collection_get_all_closed_debt_collection_actions(&self,id: String,
                         from: DateTime,
                         to: DateTime,
                         offset: Option<i64>,
                         limit: Option<i64>,
                         sortingfield: Option<String>,
                         asc: Option<bool>,
                         
) -> Result<DebtCollectionActionSubsView> {


    let path_and_query = PathAndQueryBuilder::default()
        .url(Param::value("v1"))
        .url(Param::value("debtcollection"))
        .url(Param::value("closed"))
        .url(Param::value(id))
        .query("from", Param::value(from))
        .query("to", Param::value(to))
        .query("offset", Param::opt(offset))
        .query("limit", Param::opt(limit))
        .query("sortingfield", Param::opt(sortingfield))
        .query("asc", Param::opt(asc))
        .build();






    let request = self.new_request(
        http::method::Method::GET,
        path_and_query,
    )
    
    .body(content::Empty).expect("setting json body");
    
    self.client.send::<_, content::Json<_>>(request).await
    
}
    
    

/// Please note that events older than 6 months after debt collection action was closed is archived and will not be returned with this call.
/// - **id**: Creditor public id
/// - **from**: From date
/// - **to**: To date
pub async fn debt_collection_get_all_events_for_all_debt_collections(&self,id: Guid,
                         from: DateTime,
                         to: DateTime,
                         
) -> Result<CommonActionEventsView> {


    let path_and_query = PathAndQueryBuilder::default()
        .url(Param::value("v1"))
        .url(Param::value("debtcollection"))
        .url(Param::value("events"))
        .url(Param::value(id))
        .query("from", Param::value(from))
        .query("to", Param::value(to))
        .build();






    let request = self.new_request(
        http::method::Method::GET,
        path_and_query,
    )
    
    .body(content::Empty).expect("setting json body");
    
    self.client.send::<_, content::Json<_>>(request).await
    
}
    
    

/// Get all debt collection actions that has not been cancelled or fully paid (ie closed). Closed actions are extracted using Closed endpoint
/// - **id**: Creditor public id
/// - **offset**: Offset
/// - **limit**: Limit
/// - **sortingfield**: Sorting field
/// - **asc**: Ascending sorting. Default value is true
pub async fn debt_collection_get_all_open_debt_collection_actions(&self,id: Guid,
                         offset: Option<i64>,
                         limit: Option<i64>,
                         sortingfield: Option<String>,
                         asc: Option<bool>,
                         
) -> Result<DebtCollectionActionSubsView> {


    let path_and_query = PathAndQueryBuilder::default()
        .url(Param::value("v1"))
        .url(Param::value("debtcollection"))
        .url(Param::value("open"))
        .url(Param::value(id))
        .query("offset", Param::opt(offset))
        .query("limit", Param::opt(limit))
        .query("sortingfield", Param::opt(sortingfield))
        .query("asc", Param::opt(asc))
        .build();






    let request = self.new_request(
        http::method::Method::GET,
        path_and_query,
    )
    
    .body(content::Empty).expect("setting json body");
    
    self.client.send::<_, content::Json<_>>(request).await
    
}
    
    

/// Postpones the next automatic event on the debt collection action. Use to give debtor a little more time.
/// - **id**: Debt collection action public id
/// - **days**: Number of days to postpone next event
pub async fn debt_collection_postpone_next_event_by_days(&self,id: String,
                         days: String,
                         
) -> Result<()> {


    let path_and_query = PathAndQueryBuilder::default()
        .url(Param::value("v1"))
        .url(Param::value("debtcollection"))
        .url(Param::value("postpone"))
        .url(Param::value(id))
        .query("days", Param::value(days))
        .build();






    let request = self.new_request(
        http::method::Method::PUT,
        path_and_query,
    )
    
    .body(content::Empty).expect("setting json body");
    
    
    self.client.send::<_, content::Empty>(request).await
    
}
    
    

/// Postpones the next automatic event on the debt collection action. Use to give debtor a little more time.
/// - **id**: Debt collection action public id
/// - **date**: Date to postpone to
pub async fn debt_collection_postpone_next_event_until(&self,id: String,
                         date: DateTime,
                         
) -> Result<()> {


    let path_and_query = PathAndQueryBuilder::default()
        .url(Param::value("v1"))
        .url(Param::value("debtcollection"))
        .url(Param::value("postpone"))
        .url(Param::value(id))
        .query("date", Param::value(date))
        .build();






    let request = self.new_request(
        http::method::Method::PUT,
        path_and_query,
    )
    
    .body(content::Empty).expect("setting json body");
    
    
    self.client.send::<_, content::Empty>(request).await
    
}
    
    

/// Overrides the debtor card address and sets a temporary address for this debt collection action only
pub async fn debt_collection_update_address_on_an_action(&self,body: UpdateAddressActionView,
                         
) -> Result<()> {


    let path_and_query = PathAndQueryBuilder::default()
        .url(Param::value("v1"))
        .url(Param::value("debtcollection"))
        .url(Param::value("address"))
        .build();






    let request = self.new_request(
        http::method::Method::PUT,
        path_and_query,
    )
    .body(content::Json(body)).expect("setting json body");
    
    
    self.client.send::<_, content::Empty>(request).await
    
}
    
}