use crate::{
    models::{CreatedView, DebentureActionEntryView, Guid},
    Client, Param, PathAndQueryBuilder, Result,
};
use eiktyrner::{content, HttpClient};

impl Client {
    pub async fn debenture_create_debenture(
        &self,
        body: DebentureActionEntryView,
    ) -> Result<CreatedView> {
        let path_and_query = PathAndQueryBuilder::default()
            .url(Param::value("v1"))
            .url(Param::value("invoice"))
            .url(Param::value("debentureaction"))
            .build();

        let request = self
            .new_request(http::method::Method::POST, path_and_query)
            .body(content::Json(body))
            .expect("setting json body");

        self.client.send::<_, content::Json<_>>(request).await
    }

    pub async fn debenture_update_debenture(
        &self,
        body: DebentureActionEntryView,
    ) -> Result<CreatedView> {
        let path_and_query = PathAndQueryBuilder::default()
            .url(Param::value("v1"))
            .url(Param::value("invoice"))
            .url(Param::value("debentureaction"))
            .build();

        let request = self
            .new_request(http::method::Method::PUT, path_and_query)
            .body(content::Json(body))
            .expect("setting json body");

        self.client.send::<_, content::Json<_>>(request).await
    }

    pub async fn debenture_delete_debenture(&self, id: Guid) -> Result<()> {
        let path_and_query = PathAndQueryBuilder::default()
            .url(Param::value("v1"))
            .url(Param::value("invoice"))
            .url(Param::value("debentureaction"))
            .url(Param::value(id))
            .build();

        let request = self
            .new_request(http::method::Method::DELETE, path_and_query)
            .body(content::Empty)
            .expect("setting json body");

        self.client.send::<_, content::Empty>(request).await
    }
}