use eiktyrner::{content, HttpClient};
use crate::{Param, PathAndQueryBuilder, Result};

use crate::Client;
use crate::models::{
     AccountingExportCreationView,
     AccountingExportFormatTypeView,
     AccountingExportView,
     AccountingExportsView,
     AccountingPaymentMeanView,
     AccountingPaymentMeansView,
     AccountingSettingsView,
     DateTime,
     Guid,
     LockedPeriodView,
    
};


impl Client {
    
    

/// 
pub async fn accounting_create_a_payment_mean(&self,body: AccountingPaymentMeanView,
                         
) -> Result<()> {


    let path_and_query = PathAndQueryBuilder::default()
        .url(Param::value("v1"))
        .url(Param::value("accounting"))
        .url(Param::value("paymentmeans"))
        .build();






    let request = self.new_request(
        http::method::Method::POST,
        path_and_query,
    )
    .body(content::Json(body)).expect("setting json body");
    
    
    self.client.send::<_, content::Empty>(request).await
    
}
    
    

/// Generates a new bookkeeping file (SIE4, Visma, etc) file for import in external bookkeeping application. Parameter 'Period' can be any date in the month and bookkeeping data for the entire full month will be written to file. Bookkeeping export is retrieved using GET. Addon 'CSV-bookkeeping' must be added in Portal before CSV format can be used. Setting BookKeepingTypesFilter to empty list is equal to specifying all types.
pub async fn accounting_create_accounting_bookkeeping_file_for_a_specific_month_with_content(&self,body: AccountingExportCreationView,
                         
) -> Result<AccountingExportView> {


    let path_and_query = PathAndQueryBuilder::default()
        .url(Param::value("v1"))
        .url(Param::value("accounting"))
        .url(Param::value("accountingexports"))
        .build();






    let request = self.new_request(
        http::method::Method::PUT,
        path_and_query,
    )
    .body(content::Json(body)).expect("setting json body");
    
    self.client.send::<_, content::Json<_>>(request).await
    
}
    
    

/// Generates a new bookkeeping file (SIE4, Visma, etc) file for import in external bookkeeping application. Parameter 'Period' can be any date in the month and bookkeeping data for the entire full month will be written to file. Bookkeeping export is retrieved using GET. Addon 'CSV-bookkeeping' must be added in Portal before CSV format can be used
/// - **id**: Creditor public id
/// - **period**: The period to export
/// - **format**: The file format to export to. Defaulted to SIE4 if not specified
pub async fn accounting_create_accounting_bookkeeping_file_for_a_specific_month_with_parameters(&self,id: Guid,
                         period: DateTime,
                         format: AccountingExportFormatTypeView,
                         
) -> Result<AccountingExportView> {


    let path_and_query = PathAndQueryBuilder::default()
        .url(Param::value("v1"))
        .url(Param::value("accounting"))
        .url(Param::value("accountingexports"))
        .url(Param::value(id))
        .query("period", Param::value(period))
        .query("format", Param::value(format))
        .build();






    let request = self.new_request(
        http::method::Method::PUT,
        path_and_query,
    )
    
    .body(content::Empty).expect("setting json body");
    
    self.client.send::<_, content::Json<_>>(request).await
    
}
    
    

/// Deletes a payment mean if possible. Used payment means can't be deleted and will return a Bad Request response
/// - **id**: Creditor public id
/// - **paymentmeancode**: Payment mean code
pub async fn accounting_delete_a_payment_mean(&self,id: Guid,
                         paymentmeancode: String,
                         
) -> Result<()> {


    let path_and_query = PathAndQueryBuilder::default()
        .url(Param::value("v1"))
        .url(Param::value("accounting"))
        .url(Param::value("paymentmeans"))
        .url(Param::value(id))
        .query("paymentmeancode", Param::value(paymentmeancode))
        .build();






    let request = self.new_request(
        http::method::Method::DELETE,
        path_and_query,
    )
    
    .body(content::Empty).expect("setting json body");
    
    
    self.client.send::<_, content::Empty>(request).await
    
}
    
    

/// 
/// - **id**: Creditor public id
pub async fn accounting_delete_locked_bookeeping_period(&self,id: Guid,
                         
) -> Result<()> {


    let path_and_query = PathAndQueryBuilder::default()
        .url(Param::value("v1"))
        .url(Param::value("accounting"))
        .url(Param::value("lockedperiod"))
        .url(Param::value(id))
        .build();






    let request = self.new_request(
        http::method::Method::DELETE,
        path_and_query,
    )
    
    .body(content::Empty).expect("setting json body");
    
    
    self.client.send::<_, content::Empty>(request).await
    
}
    
    

/// Returns a single defined payment mean (method of payment and their bookkeeping setup).
/// - **id**: Creditor public id
/// - **paymentmeancode**: Payment mean code
pub async fn accounting_get_a_single_payment_mean(&self,id: Guid,
                         paymentmeancode: String,
                         
) -> Result<AccountingPaymentMeanView> {


    let path_and_query = PathAndQueryBuilder::default()
        .url(Param::value("v1"))
        .url(Param::value("accounting"))
        .url(Param::value("paymentmeans"))
        .url(Param::value(id))
        .query("paymentmeancode", Param::value(paymentmeancode))
        .build();






    let request = self.new_request(
        http::method::Method::GET,
        path_and_query,
    )
    
    .body(content::Empty).expect("setting json body");
    
    self.client.send::<_, content::Json<_>>(request).await
    
}
    
    

/// Returns all generated bookkeeping files (SIE4, Visma, etc). Exports are not generated automatically and must be triggered by users in Portal or API (see PUT method).
/// - **id**: Creditor public id
pub async fn accounting_get_accounting_bookkeeping_export_files_sie4_etc(&self,id: Guid,
                         
) -> Result<AccountingExportsView> {


    let path_and_query = PathAndQueryBuilder::default()
        .url(Param::value("v1"))
        .url(Param::value("accounting"))
        .url(Param::value("accountingexports"))
        .url(Param::value(id))
        .build();






    let request = self.new_request(
        http::method::Method::GET,
        path_and_query,
    )
    
    .body(content::Empty).expect("setting json body");
    
    self.client.send::<_, content::Json<_>>(request).await
    
}
    
    

/// Accounting/Bookkeeping settings are the creditors configuration on how bookkeeping events should be handled in the system. If no settings have been defined the default setting will be used (see Bookkeeping settings in portal)
/// - **id**: Creditor public id
pub async fn accounting_get_accounting_bookkeeping_settings(&self,id: Guid,
                         
) -> Result<AccountingSettingsView> {


    let path_and_query = PathAndQueryBuilder::default()
        .url(Param::value("v1"))
        .url(Param::value("accounting"))
        .url(Param::value("accountingsettings"))
        .url(Param::value(id))
        .build();






    let request = self.new_request(
        http::method::Method::GET,
        path_and_query,
    )
    
    .body(content::Empty).expect("setting json body");
    
    self.client.send::<_, content::Json<_>>(request).await
    
}
    
    

/// Get locked period for the bookkeeping. You can set the period to a date and no invoices can be attested before or on that date
/// - **id**: Creditor public id
pub async fn accounting_get_locked_bookeeping_period(&self,id: Guid,
                         
) -> Result<LockedPeriodView> {


    let path_and_query = PathAndQueryBuilder::default()
        .url(Param::value("v1"))
        .url(Param::value("accounting"))
        .url(Param::value("lockedperiod"))
        .url(Param::value(id))
        .build();






    let request = self.new_request(
        http::method::Method::GET,
        path_and_query,
    )
    
    .body(content::Empty).expect("setting json body");
    
    self.client.send::<_, content::Json<_>>(request).await
    
}
    
    

/// Returns all defined payment means (method of payment and their bookkeeping setup).
/// - **id**: Creditor public id
pub async fn accounting_get_payment_means(&self,id: Guid,
                         
) -> Result<AccountingPaymentMeansView> {


    let path_and_query = PathAndQueryBuilder::default()
        .url(Param::value("v1"))
        .url(Param::value("accounting"))
        .url(Param::value("paymentmeans"))
        .url(Param::value(id))
        .build();






    let request = self.new_request(
        http::method::Method::GET,
        path_and_query,
    )
    
    .body(content::Empty).expect("setting json body");
    
    self.client.send::<_, content::Json<_>>(request).await
    
}
    
    

/// 
pub async fn accounting_update_a_payment_mean(&self,body: AccountingPaymentMeanView,
                         
) -> Result<()> {


    let path_and_query = PathAndQueryBuilder::default()
        .url(Param::value("v1"))
        .url(Param::value("accounting"))
        .url(Param::value("paymentmeans"))
        .build();






    let request = self.new_request(
        http::method::Method::PUT,
        path_and_query,
    )
    .body(content::Json(body)).expect("setting json body");
    
    
    self.client.send::<_, content::Empty>(request).await
    
}
    
    

/// 
pub async fn accounting_update_accounting_bookkeeping_settings(&self,body: AccountingSettingsView,
                         
) -> Result<()> {


    let path_and_query = PathAndQueryBuilder::default()
        .url(Param::value("v1"))
        .url(Param::value("accounting"))
        .url(Param::value("accountingsettings"))
        .build();






    let request = self.new_request(
        http::method::Method::PUT,
        path_and_query,
    )
    .body(content::Json(body)).expect("setting json body");
    
    
    self.client.send::<_, content::Empty>(request).await
    
}
    
    

/// The to date is inclusive
/// - **id**: Creditor public id
/// - **to**: To date
pub async fn accounting_update_the_locked_bookeeping_period(&self,id: Guid,
                         to: DateTime,
                         
) -> Result<()> {


    let path_and_query = PathAndQueryBuilder::default()
        .url(Param::value("v1"))
        .url(Param::value("accounting"))
        .url(Param::value("lockedperiod"))
        .url(Param::value(id))
        .query("to", Param::value(to))
        .build();






    let request = self.new_request(
        http::method::Method::POST,
        path_and_query,
    )
    
    .body(content::Empty).expect("setting json body");
    
    
    self.client.send::<_, content::Empty>(request).await
    
}
    
}