use eiktyrner::{content, HttpClient};
use crate::{Param, PathAndQueryBuilder, Result};

use crate::Client;
use crate::models::{
     SearchResultView,
     SearchView,
    
};


impl Client {
    
    

/// Search for you invoice, claims etc through the Search endpoint. All properties are allowed to be null and mean that no filtering is made on that field. The SearchValue property can only contain the complete invoice number or OCR you are searching for (no other values like debtor, product name etc). It is possible to omit it.
pub async fn search_search_for_actions(&self,body: SearchView,
                         
) -> Result<SearchResultView> {


    let path_and_query = PathAndQueryBuilder::default()
        .url(Param::value("v1"))
        .url(Param::value("search"))
        .url(Param::value("actions"))
        .build();






    let request = self.new_request(
        http::method::Method::POST,
        path_and_query,
    )
    .body(content::Json(body)).expect("setting json body");
    
    self.client.send::<_, content::Json<_>>(request).await
    
}
    
}