
use crate::models::ActionTypeView; 
use crate::models::AmountView; 
use crate::models::DateTime; 
use crate::models::DebtorView; 
use crate::models::DeliveryMethodTypeView; 
use crate::models::FileView; 
use crate::models::Guid; 
use crate::models::LanguageTypeView; 
use crate::models::ReferenceTypeView; 
use crate::models::SelfInvoiceActionAttachmentView; 
use crate::models::SelfInvoiceActionEventView; 
use crate::models::SelfInvoiceActionInvoiceView; 
use crate::models::SelfInvoiceActionRecordView; 
use crate::models::SelfInvoiceActionStateView; 

#[derive(Debug, Clone, serde::Serialize, serde::Deserialize, Default)]
pub struct SelfInvoiceActionView {
    
    #[serde(rename = "ActionPublicId", skip_serializing_if = "Option::is_none")]
    pub action_public_id: Option<String>,
    
    #[serde(rename = "ActionType", skip_serializing_if = "Option::is_none")]
    pub action_type: Option<ActionTypeView>,
    
    #[serde(rename = "Appendixes", skip_serializing_if = "Vec::is_empty", default)]
    pub appendixes: Vec<FileView>,
    
    #[serde(rename = "Attachments", skip_serializing_if = "Vec::is_empty", default)]
    pub attachments: Vec<SelfInvoiceActionAttachmentView>,
    
    #[serde(rename = "BankgiroNo", skip_serializing_if = "Option::is_none")]
    pub bankgiro_no: Option<String>,
    
    #[serde(rename = "CanCancel", skip_serializing_if = "Option::is_none")]
    pub can_cancel: Option<bool>,
    
    #[serde(rename = "CanCredit", skip_serializing_if = "Option::is_none")]
    pub can_credit: Option<bool>,
    
    #[serde(rename = "CanMakeManual", skip_serializing_if = "Option::is_none")]
    pub can_make_manual: Option<bool>,
    
    #[serde(rename = "CanPause", skip_serializing_if = "Option::is_none")]
    pub can_pause: Option<bool>,
    
    #[serde(rename = "CanRegisterPayment", skip_serializing_if = "Option::is_none")]
    pub can_register_payment: Option<bool>,
    
    #[serde(rename = "CanResendManualInvoice", skip_serializing_if = "Option::is_none")]
    pub can_resend_manual_invoice: Option<bool>,
    
    #[serde(rename = "CanResume", skip_serializing_if = "Option::is_none")]
    pub can_resume: Option<bool>,
    
    #[serde(rename = "CanSendManualInvoice", skip_serializing_if = "Option::is_none")]
    pub can_send_manual_invoice: Option<bool>,
    
    #[serde(rename = "CommunicationLanguage", skip_serializing_if = "Option::is_none")]
    pub communication_language: Option<LanguageTypeView>,
    
    #[serde(rename = "Created", skip_serializing_if = "Option::is_none")]
    pub created: Option<DateTime>,
    
    #[serde(rename = "CreditedAmount", skip_serializing_if = "Option::is_none")]
    pub credited_amount: Option<AmountView>,
    
    #[serde(rename = "CreditingSelfInvoicePublicId", skip_serializing_if = "Option::is_none")]
    pub crediting_self_invoice_public_id: Option<String>,
    
    #[serde(rename = "CreditorPublicId", skip_serializing_if = "Option::is_none")]
    pub creditor_public_id: Option<Guid>,
    
    #[serde(rename = "CurrentAmount", skip_serializing_if = "Option::is_none")]
    pub current_amount: Option<AmountView>,
    
    #[serde(rename = "Debtor", skip_serializing_if = "Option::is_none")]
    pub debtor: Option<DebtorView>,
    
    #[serde(rename = "DeliveryDate", skip_serializing_if = "Option::is_none")]
    pub delivery_date: Option<DateTime>,
    
    #[serde(rename = "DeliveryMethod", skip_serializing_if = "Option::is_none")]
    pub delivery_method: Option<DeliveryMethodTypeView>,
    
    #[serde(rename = "DueDate", skip_serializing_if = "Option::is_none")]
    pub due_date: Option<DateTime>,
    
    #[serde(rename = "Events", skip_serializing_if = "Vec::is_empty", default)]
    pub events: Vec<SelfInvoiceActionEventView>,
    
    #[serde(rename = "InterestAmount", skip_serializing_if = "Option::is_none")]
    pub interest_amount: Option<AmountView>,
    
    #[serde(rename = "InvoiceDate", skip_serializing_if = "Option::is_none")]
    pub invoice_date: Option<DateTime>,
    
    #[serde(rename = "InvoicedAmount", skip_serializing_if = "Option::is_none")]
    pub invoiced_amount: Option<AmountView>,
    
    #[serde(rename = "Invoices", skip_serializing_if = "Vec::is_empty", default)]
    pub invoices: Vec<SelfInvoiceActionInvoiceView>,
    
    #[serde(rename = "Message", skip_serializing_if = "Option::is_none")]
    pub message: Option<String>,
    
    #[serde(rename = "OurReference", skip_serializing_if = "Option::is_none")]
    pub our_reference: Option<String>,
    
    #[serde(rename = "PaidAmount", skip_serializing_if = "Option::is_none")]
    pub paid_amount: Option<AmountView>,
    
    #[serde(rename = "PaymentTermsInDays", skip_serializing_if = "Option::is_none")]
    pub payment_terms_in_days: Option<i64>,
    
    #[serde(rename = "Records", skip_serializing_if = "Vec::is_empty", default)]
    pub records: Vec<SelfInvoiceActionRecordView>,
    
    #[serde(rename = "State", skip_serializing_if = "Option::is_none")]
    pub state: Option<SelfInvoiceActionStateView>,
    
    #[serde(rename = "TotalVATAmount", skip_serializing_if = "Option::is_none")]
    pub total_vat_amount: Option<AmountView>,
    
    #[serde(rename = "TransferReference", skip_serializing_if = "Option::is_none")]
    pub transfer_reference: Option<String>,
    
    #[serde(rename = "TransferReferenceType", skip_serializing_if = "Option::is_none")]
    pub transfer_reference_type: Option<ReferenceTypeView>,
    
    #[serde(rename = "YourReference", skip_serializing_if = "Option::is_none")]
    pub your_reference: Option<String>,
    
}