
use crate::models::Guid; 
use crate::models::ProductTypeView; 

#[derive(Debug, Clone, serde::Serialize, serde::Deserialize, Default)]
pub struct ProductsTemplateView {
    
    #[serde(rename = "CreditorPublicId", skip_serializing_if = "Option::is_none")]
    pub creditor_public_id: Option<Guid>,
    
    #[serde(rename = "DefaultProductType", skip_serializing_if = "Option::is_none")]
    pub default_product_type: Option<ProductTypeView>,
    
    #[serde(rename = "DefaultPurchaseAccount", skip_serializing_if = "Option::is_none")]
    pub default_purchase_account: Option<i64>,
    
    #[serde(rename = "DefaultPurchaseVATAccount", skip_serializing_if = "Option::is_none")]
    pub default_purchase_vat_account: Option<i64>,
    
    #[serde(rename = "DefaultSalesAccount", skip_serializing_if = "Option::is_none")]
    pub default_sales_account: Option<i64>,
    
    #[serde(rename = "DefaultSalesEUAccount", skip_serializing_if = "Option::is_none")]
    pub default_sales_eu_account: Option<i64>,
    
    #[serde(rename = "DefaultSalesEUVATAccount", skip_serializing_if = "Option::is_none")]
    pub default_sales_euvat_account: Option<i64>,
    
    #[serde(rename = "DefaultSalesNonEUAccount", skip_serializing_if = "Option::is_none")]
    pub default_sales_non_eu_account: Option<i64>,
    
    #[serde(rename = "DefaultSalesUnits", skip_serializing_if = "Option::is_none")]
    pub default_sales_units: Option<String>,
    
    #[serde(rename = "DefaultSalesVAT", skip_serializing_if = "Option::is_none")]
    pub default_sales_vat: Option<f64>,
    
    #[serde(rename = "DefaultVATAccount", skip_serializing_if = "Option::is_none")]
    pub default_vat_account: Option<i64>,
    
}