
use crate::models::Guid; 

#[derive(Debug, Clone, serde::Serialize, serde::Deserialize, Default)]
pub struct PaymentMatchResultView {
    
    #[serde(rename = "ResponseMessage", skip_serializing_if = "Option::is_none")]
    pub response_message: Option<String>,
    
    #[serde(rename = "Successfull", skip_serializing_if = "Option::is_none")]
    pub successfull: Option<bool>,
    
    #[serde(rename = "UnhandledPaymentPublicId", skip_serializing_if = "Option::is_none")]
    pub unhandled_payment_public_id: Option<Guid>,
    
}