
use crate::models::AmountView; 
use crate::models::DateTime; 
use crate::models::FileView; 
use crate::models::Guid; 
use crate::models::OutgoingPaymentStatusTypeView; 

#[derive(Debug, Clone, serde::Serialize, serde::Deserialize, Default)]
pub struct OutgoingPaymentStatusView {
    
    #[serde(rename = "Amount", skip_serializing_if = "Option::is_none")]
    pub amount: Option<AmountView>,
    
    #[serde(rename = "Comment", skip_serializing_if = "Option::is_none")]
    pub comment: Option<String>,
    
    #[serde(rename = "CreditorPublicId", skip_serializing_if = "Option::is_none")]
    pub creditor_public_id: Option<Guid>,
    
    #[serde(rename = "File", skip_serializing_if = "Option::is_none")]
    pub file: Option<FileView>,
    
    #[serde(rename = "IsSalaryPayment", skip_serializing_if = "Option::is_none")]
    pub is_salary_payment: Option<bool>,
    
    #[serde(rename = "PaymentDate", skip_serializing_if = "Option::is_none")]
    pub payment_date: Option<DateTime>,
    
    #[serde(rename = "PaymentPublicId", skip_serializing_if = "Option::is_none")]
    pub payment_public_id: Option<Guid>,
    
    #[serde(rename = "ReceiverName", skip_serializing_if = "Option::is_none")]
    pub receiver_name: Option<String>,
    
    #[serde(rename = "ReceivingAccountNo", skip_serializing_if = "Option::is_none")]
    pub receiving_account_no: Option<String>,
    
    #[serde(rename = "ReceivingBankgiroNo", skip_serializing_if = "Option::is_none")]
    pub receiving_bankgiro_no: Option<String>,
    
    #[serde(rename = "ReceivingClearingNo", skip_serializing_if = "Option::is_none")]
    pub receiving_clearing_no: Option<String>,
    
    #[serde(rename = "ReceivingPlusgiroNo", skip_serializing_if = "Option::is_none")]
    pub receiving_plusgiro_no: Option<String>,
    
    #[serde(rename = "Reference", skip_serializing_if = "Option::is_none")]
    pub reference: Option<String>,
    
    #[serde(rename = "SendingBankgiroNo", skip_serializing_if = "Option::is_none")]
    pub sending_bankgiro_no: Option<String>,
    
    #[serde(rename = "Status", skip_serializing_if = "Option::is_none")]
    pub status: Option<OutgoingPaymentStatusTypeView>,
    
    #[serde(rename = "VerificationDate", skip_serializing_if = "Option::is_none")]
    pub verification_date: Option<DateTime>,
    
}