
use crate::models::Base64; 
use crate::models::FileView; 
use crate::models::Guid; 

#[derive(Debug, Clone, serde::Serialize, serde::Deserialize, Default)]
pub struct MailDeliveryView {
    
    #[serde(rename = "Appendixes", skip_serializing_if = "Vec::is_empty", default)]
    pub appendixes: Vec<Base64>,
    
    #[serde(rename = "CreditorPublicId", skip_serializing_if = "Option::is_none")]
    pub creditor_public_id: Option<Guid>,
    
    #[serde(rename = "File", skip_serializing_if = "Option::is_none")]
    pub file: Option<FileView>,
    
    #[serde(rename = "SendAsPriorityMail", skip_serializing_if = "Option::is_none")]
    pub send_as_priority_mail: Option<bool>,
    
    #[serde(rename = "SendWithColor", skip_serializing_if = "Option::is_none")]
    pub send_with_color: Option<bool>,
    
}