
use crate::models::DateTime; 
use crate::models::Guid; 

#[derive(Debug, Clone, serde::Serialize, serde::Deserialize, Default)]
pub struct LockedPeriodView {
    
    #[serde(rename = "CreditorPublicId", skip_serializing_if = "Option::is_none")]
    pub creditor_public_id: Option<Guid>,
    
    #[serde(rename = "To", skip_serializing_if = "Option::is_none")]
    pub to: Option<DateTime>,
    
}