
use crate::models::DateTime; 
use crate::models::Guid; 
use crate::models::InvoiceActionStageTypeView; 

#[derive(Debug, Clone, serde::Serialize, serde::Deserialize, Default)]
pub struct InvoiceActionStateView {
    
    #[serde(rename = "AttestedDate", skip_serializing_if = "Option::is_none")]
    pub attested_date: Option<DateTime>,
    
    #[serde(rename = "ClosedDate", skip_serializing_if = "Option::is_none")]
    pub closed_date: Option<DateTime>,
    
    #[serde(rename = "CreditCardPaymentPublicId", skip_serializing_if = "Option::is_none")]
    pub credit_card_payment_public_id: Option<Guid>,
    
    #[serde(rename = "DisputedDate", skip_serializing_if = "Option::is_none")]
    pub disputed_date: Option<DateTime>,
    
    #[serde(rename = "InvoiceSentDate", skip_serializing_if = "Option::is_none")]
    pub invoice_sent_date: Option<DateTime>,
    
    #[serde(rename = "IsLocked", skip_serializing_if = "Option::is_none")]
    pub is_locked: Option<bool>,
    
    #[serde(rename = "IsPaused", skip_serializing_if = "Option::is_none")]
    pub is_paused: Option<bool>,
    
    #[serde(rename = "NextEvent", skip_serializing_if = "Option::is_none")]
    pub next_event: Option<String>,
    
    #[serde(rename = "NextEventDate", skip_serializing_if = "Option::is_none")]
    pub next_event_date: Option<DateTime>,
    
    #[serde(rename = "SalesRequestedDate", skip_serializing_if = "Option::is_none")]
    pub sales_requested_date: Option<DateTime>,
    
    #[serde(rename = "SentToDebtCollectionDate", skip_serializing_if = "Option::is_none")]
    pub sent_to_debt_collection_date: Option<DateTime>,
    
    #[serde(rename = "SmsSentDate", skip_serializing_if = "Option::is_none")]
    pub sms_sent_date: Option<DateTime>,
    
    #[serde(rename = "Stage", skip_serializing_if = "Option::is_none")]
    pub stage: Option<InvoiceActionStageTypeView>,
    
    #[serde(rename = "SwishPaymentPublicId", skip_serializing_if = "Option::is_none")]
    pub swish_payment_public_id: Option<String>,
    
    #[serde(rename = "UseDebtorBalance", skip_serializing_if = "Option::is_none")]
    pub use_debtor_balance: Option<bool>,
    
}