
use crate::models::ActionTypeView; 
use crate::models::AmountView; 
use crate::models::AutogiroWithdrawalView; 
use crate::models::CreditCardWithdrawalView; 
use crate::models::DateTime; 
use crate::models::DebtCollectionDetailsView; 
use crate::models::DeliveryAddressOverrideView; 
use crate::models::DeliveryMethodTypeView; 
use crate::models::Guid; 
use crate::models::InterestTypeView; 
use crate::models::InvoiceActionAttachmentView; 
use crate::models::InvoiceActionRecordView; 
use crate::models::InvoiceFileView; 
use crate::models::LanguageTypeView; 
use crate::models::PaymentOverrideView; 
use crate::models::ReminderInvoiceDetailsView; 
use crate::models::ReverseVATDetailsView; 
use crate::models::RotRutDetailsView; 

#[derive(Debug, Clone, serde::Serialize, serde::Deserialize, Default)]
pub struct InvoiceActionEntryView {
    
    #[serde(rename = "ActionType", skip_serializing_if = "Option::is_none")]
    pub action_type: Option<ActionTypeView>,
    
    #[serde(rename = "Attachments", skip_serializing_if = "Vec::is_empty", default)]
    pub attachments: Vec<InvoiceActionAttachmentView>,
    
    #[serde(rename = "Autogiro", skip_serializing_if = "Option::is_none")]
    pub autogiro: Option<AutogiroWithdrawalView>,
    
    #[serde(rename = "CommunicationLanguage", skip_serializing_if = "Option::is_none")]
    pub communication_language: Option<LanguageTypeView>,
    
    #[serde(rename = "CreditCard", skip_serializing_if = "Option::is_none")]
    pub credit_card: Option<CreditCardWithdrawalView>,
    
    #[serde(rename = "CreditingInvoicePublicId", skip_serializing_if = "Option::is_none")]
    pub crediting_invoice_public_id: Option<String>,
    
    #[serde(rename = "CreditorPublicId", skip_serializing_if = "Option::is_none")]
    pub creditor_public_id: Option<Guid>,
    
    #[serde(rename = "DebtCollectionDetails", skip_serializing_if = "Option::is_none")]
    pub debt_collection_details: Option<DebtCollectionDetailsView>,
    
    #[serde(rename = "DebtorPublicId", skip_serializing_if = "Option::is_none")]
    pub debtor_public_id: Option<Guid>,
    
    #[serde(rename = "DeliveryAddressOverride", skip_serializing_if = "Option::is_none")]
    pub delivery_address_override: Option<DeliveryAddressOverrideView>,
    
    #[serde(rename = "DeliveryDate", skip_serializing_if = "Option::is_none")]
    pub delivery_date: Option<DateTime>,
    
    #[serde(rename = "DeliveryMethod", skip_serializing_if = "Option::is_none")]
    pub delivery_method: Option<DeliveryMethodTypeView>,
    
    #[serde(rename = "DueDate", skip_serializing_if = "Option::is_none")]
    pub due_date: Option<DateTime>,
    
    #[serde(rename = "ExternalReference", skip_serializing_if = "Option::is_none")]
    pub external_reference: Option<String>,
    
    #[serde(rename = "FreightFee", skip_serializing_if = "Option::is_none")]
    pub freight_fee: Option<AmountView>,
    
    #[serde(rename = "InterestPercentage", skip_serializing_if = "Option::is_none")]
    pub interest_percentage: Option<f64>,
    
    #[serde(rename = "InterestStartInDaysAfterDueDate", skip_serializing_if = "Option::is_none")]
    pub interest_start_in_days_after_due_date: Option<i64>,
    
    #[serde(rename = "InterestType", skip_serializing_if = "Option::is_none")]
    pub interest_type: Option<InterestTypeView>,
    
    #[serde(rename = "InvoiceDate", skip_serializing_if = "Option::is_none")]
    pub invoice_date: Option<DateTime>,
    
    #[serde(rename = "InvoiceFee", skip_serializing_if = "Option::is_none")]
    pub invoice_fee: Option<AmountView>,
    
    #[serde(rename = "InvoiceNumber", skip_serializing_if = "Option::is_none")]
    pub invoice_number: Option<String>,
    
    #[serde(rename = "InvoicePDF", skip_serializing_if = "Option::is_none")]
    pub invoice_pdf: Option<InvoiceFileView>,
    
    #[serde(rename = "IsLocked", skip_serializing_if = "Option::is_none")]
    pub is_locked: Option<bool>,
    
    #[serde(rename = "Message", skip_serializing_if = "Option::is_none")]
    pub message: Option<String>,
    
    #[serde(rename = "OurReference", skip_serializing_if = "Option::is_none")]
    pub our_reference: Option<String>,
    
    #[serde(rename = "PaymentOverride", skip_serializing_if = "Option::is_none")]
    pub payment_override: Option<PaymentOverrideView>,
    
    #[serde(rename = "ReasonForHigherInterest", skip_serializing_if = "Option::is_none")]
    pub reason_for_higher_interest: Option<String>,
    
    #[serde(rename = "Records", skip_serializing_if = "Vec::is_empty", default)]
    pub records: Vec<InvoiceActionRecordView>,
    
    #[serde(rename = "ReminderInvoiceDetails", skip_serializing_if = "Option::is_none")]
    pub reminder_invoice_details: Option<ReminderInvoiceDetailsView>,
    
    #[serde(rename = "ReverseVATDetails", skip_serializing_if = "Option::is_none")]
    pub reverse_vat_details: Option<ReverseVATDetailsView>,
    
    #[serde(rename = "RotRutDetails", skip_serializing_if = "Option::is_none")]
    pub rot_rut_details: Option<RotRutDetailsView>,
    
    #[serde(rename = "SendByMailIfEmailNotViewedInDays", skip_serializing_if = "Option::is_none")]
    pub send_by_mail_if_email_not_viewed_in_days: Option<i64>,
    
    #[serde(rename = "UseDebtorBalance", skip_serializing_if = "Option::is_none")]
    pub use_debtor_balance: Option<bool>,
    
    #[serde(rename = "VatIsIncluded", skip_serializing_if = "Option::is_none")]
    pub vat_is_included: Option<bool>,
    
    #[serde(rename = "YourReference", skip_serializing_if = "Option::is_none")]
    pub your_reference: Option<String>,
    
}