use std::fmt;


#[derive(Debug, Clone, Copy, serde::Serialize, serde::Deserialize, PartialEq, Eq)]
#[serde(rename_all = "PascalCase")]
#[allow(non_camel_case_types)]
pub enum FiscalYearTypeView {
    
    AprToMar,
    AugToJul,
    CalendarYear,
    DecToNov,
    FebToJan,
    JulToJun,
    JunToMay,
    MarToFeb,
    MayToApr,
    NovToOct,
    OctToSep,
    SepToAug,

}


impl fmt::Display for FiscalYearTypeView {


    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(f, "{:?}", self)
    }
    
}