
use crate::models::AmountView; 
use crate::models::DebtCollectionActionLevelTypeView; 
use crate::models::DeliveryMethodTypeView; 
use crate::models::Guid; 
use crate::models::IncomingPaymentNotificationMethodTypeView; 
use crate::models::InterestTypeView; 
use crate::models::LanguageTypeView; 

#[derive(Debug, Clone, serde::Serialize, serde::Deserialize, Default)]
pub struct DefaultActionConfigView {
    
    #[serde(rename = "AutomaticInvoiceWriteOffThresholds", skip_serializing_if = "Vec::is_empty", default)]
    pub automatic_invoice_write_off_thresholds: Vec<AmountView>,
    
    #[serde(rename = "CommunicationLanguage", skip_serializing_if = "Option::is_none")]
    pub communication_language: Option<LanguageTypeView>,
    
    #[serde(rename = "CreditorPublicId", skip_serializing_if = "Option::is_none")]
    pub creditor_public_id: Option<Guid>,
    
    #[serde(rename = "CurrencyCode", skip_serializing_if = "Option::is_none")]
    pub currency_code: Option<String>,
    
    #[serde(rename = "DebtCollectionMessagePublicId", skip_serializing_if = "Option::is_none")]
    pub debt_collection_message_public_id: Option<Guid>,
    
    #[serde(rename = "DebtCollectionPaymentTermsInDays", skip_serializing_if = "Option::is_none")]
    pub debt_collection_payment_terms_in_days: Option<i64>,
    
    #[serde(rename = "DeliveryMethod", skip_serializing_if = "Option::is_none")]
    pub delivery_method: Option<DeliveryMethodTypeView>,
    
    #[serde(rename = "DoNotAutomaticallySendForeignInvoicesToDebtCollection", skip_serializing_if = "Option::is_none")]
    pub do_not_automatically_send_foreign_invoices_to_debt_collection: Option<bool>,
    
    #[serde(rename = "DontRequestDueClaimResponse", skip_serializing_if = "Option::is_none")]
    pub dont_request_due_claim_response: Option<bool>,
    
    #[serde(rename = "EndDebtCollectionActionLevel", skip_serializing_if = "Option::is_none")]
    pub end_debt_collection_action_level: Option<DebtCollectionActionLevelTypeView>,
    
    #[serde(rename = "IncludePdfInEmail", skip_serializing_if = "Option::is_none")]
    pub include_pdf_in_email: Option<bool>,
    
    #[serde(rename = "IncomingPaymentNotificationMethods", skip_serializing_if = "Vec::is_empty", default)]
    pub incoming_payment_notification_methods: Vec<IncomingPaymentNotificationMethodTypeView>,
    
    #[serde(rename = "InterestPercentage", skip_serializing_if = "Option::is_none")]
    pub interest_percentage: Option<f64>,
    
    #[serde(rename = "InterestStartInDaysAfterDueDate", skip_serializing_if = "Option::is_none")]
    pub interest_start_in_days_after_due_date: Option<i64>,
    
    #[serde(rename = "InterestType", skip_serializing_if = "Option::is_none")]
    pub interest_type: Option<InterestTypeView>,
    
    #[serde(rename = "InvoiceComment", skip_serializing_if = "Option::is_none")]
    pub invoice_comment: Option<String>,
    
    #[serde(rename = "InvoiceFee", skip_serializing_if = "Option::is_none")]
    pub invoice_fee: Option<f64>,
    
    #[serde(rename = "InvoiceFeeOnlyOnDeliveryMethods", skip_serializing_if = "Vec::is_empty", default)]
    pub invoice_fee_only_on_delivery_methods: Vec<DeliveryMethodTypeView>,
    
    #[serde(rename = "InvoicePaymentTermsInDays", skip_serializing_if = "Option::is_none")]
    pub invoice_payment_terms_in_days: Option<i64>,
    
    #[serde(rename = "MinAmountForSendingReminder", skip_serializing_if = "Option::is_none")]
    pub min_amount_for_sending_reminder: Option<f64>,
    
    #[serde(rename = "NumberOfReminders", skip_serializing_if = "Option::is_none")]
    pub number_of_reminders: Option<i64>,
    
    #[serde(rename = "OurReference", skip_serializing_if = "Option::is_none")]
    pub our_reference: Option<String>,
    
    #[serde(rename = "PaymentTermsInDays", skip_serializing_if = "Option::is_none")]
    pub payment_terms_in_days: Option<i64>,
    
    #[serde(rename = "ReasonDescription", skip_serializing_if = "Option::is_none")]
    pub reason_description: Option<String>,
    
    #[serde(rename = "ReasonForHigherInterest", skip_serializing_if = "Option::is_none")]
    pub reason_for_higher_interest: Option<String>,
    
    #[serde(rename = "ReminderGraceDays", skip_serializing_if = "Option::is_none")]
    pub reminder_grace_days: Option<i64>,
    
    #[serde(rename = "ReminderInvoiceFee", skip_serializing_if = "Option::is_none")]
    pub reminder_invoice_fee: Option<f64>,
    
    #[serde(rename = "ReminderInvoicePaymentTermsInDays", skip_serializing_if = "Option::is_none")]
    pub reminder_invoice_payment_terms_in_days: Option<i64>,
    
    #[serde(rename = "SendAsPriorityMail", skip_serializing_if = "Option::is_none")]
    pub send_as_priority_mail: Option<bool>,
    
    #[serde(rename = "SendByMailIfEmailNotViewedInDays", skip_serializing_if = "Option::is_none")]
    pub send_by_mail_if_email_not_viewed_in_days: Option<i64>,
    
    #[serde(rename = "SendByMailIfEmailNotViewedInDaysEnabled", skip_serializing_if = "Option::is_none")]
    pub send_by_mail_if_email_not_viewed_in_days_enabled: Option<bool>,
    
    #[serde(rename = "SendDebtCollectionsWithMail", skip_serializing_if = "Option::is_none")]
    pub send_debt_collections_with_mail: Option<bool>,
    
    #[serde(rename = "SendInvoiceToDebtCollection", skip_serializing_if = "Option::is_none")]
    pub send_invoice_to_debt_collection: Option<bool>,
    
    #[serde(rename = "SendInvoiceToDebtCollectionAfterDays", skip_serializing_if = "Option::is_none")]
    pub send_invoice_to_debt_collection_after_days: Option<i64>,
    
    #[serde(rename = "SendReminderInvoice", skip_serializing_if = "Option::is_none")]
    pub send_reminder_invoice: Option<bool>,
    
    #[serde(rename = "SendReminderInvoiceDaysAfterDueDate", skip_serializing_if = "Option::is_none")]
    pub send_reminder_invoice_days_after_due_date: Option<i64>,
    
    #[serde(rename = "SendWithColor", skip_serializing_if = "Option::is_none")]
    pub send_with_color: Option<bool>,
    
    #[serde(rename = "ShowUnpaidInvoicesOnNextInvoice", skip_serializing_if = "Option::is_none")]
    pub show_unpaid_invoices_on_next_invoice: Option<bool>,
    
    #[serde(rename = "StartDebtCollectionActionLevel", skip_serializing_if = "Option::is_none")]
    pub start_debt_collection_action_level: Option<DebtCollectionActionLevelTypeView>,
    
    #[serde(rename = "UsageOfDebtorBalanceIsAppliedByDefault", skip_serializing_if = "Option::is_none")]
    pub usage_of_debtor_balance_is_applied_by_default: Option<bool>,
    
}