
use crate::models::AmountView; 
use crate::models::DateTime; 
use crate::models::DebtorContractPeriodTypeView; 
use crate::models::DebtorContractStateTypeView; 
use crate::models::FileView; 
use crate::models::Guid; 

#[derive(Debug, Clone, serde::Serialize, serde::Deserialize, Default)]
pub struct DebtorContractView {
    
    #[serde(rename = "ArchivedDate", skip_serializing_if = "Option::is_none")]
    pub archived_date: Option<DateTime>,
    
    #[serde(rename = "ContractFile", skip_serializing_if = "Option::is_none")]
    pub contract_file: Option<FileView>,
    
    #[serde(rename = "ContractInformation", skip_serializing_if = "Option::is_none")]
    pub contract_information: Option<String>,
    
    #[serde(rename = "ContractNumber", skip_serializing_if = "Option::is_none")]
    pub contract_number: Option<String>,
    
    #[serde(rename = "ContractPublicId", skip_serializing_if = "Option::is_none")]
    pub contract_public_id: Option<Guid>,
    
    #[serde(rename = "ContractState", skip_serializing_if = "Option::is_none")]
    pub contract_state: Option<DebtorContractStateTypeView>,
    
    #[serde(rename = "CreditorPublicId", skip_serializing_if = "Option::is_none")]
    pub creditor_public_id: Option<Guid>,
    
    #[serde(rename = "DebtorPublicId", skip_serializing_if = "Option::is_none")]
    pub debtor_public_id: Option<Guid>,
    
    #[serde(rename = "Description", skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    
    #[serde(rename = "Periods", skip_serializing_if = "Option::is_none")]
    pub periods: Option<i64>,
    
    #[serde(rename = "PeriodsType", skip_serializing_if = "Option::is_none")]
    pub periods_type: Option<DebtorContractPeriodTypeView>,
    
    #[serde(rename = "SentForSignatureDate", skip_serializing_if = "Option::is_none")]
    pub sent_for_signature_date: Option<DateTime>,
    
    #[serde(rename = "SentKYC", skip_serializing_if = "Option::is_none")]
    pub sent_kyc: Option<DateTime>,
    
    #[serde(rename = "SignSSN", skip_serializing_if = "Option::is_none")]
    pub sign_ssn: Option<String>,
    
    #[serde(rename = "SignedContractFile", skip_serializing_if = "Option::is_none")]
    pub signed_contract_file: Option<FileView>,
    
    #[serde(rename = "SignedDate", skip_serializing_if = "Option::is_none")]
    pub signed_date: Option<DateTime>,
    
    #[serde(rename = "TotalAmount", skip_serializing_if = "Option::is_none")]
    pub total_amount: Option<AmountView>,
    
}