
use crate::models::DateTime; 

#[derive(Debug, Clone, serde::Serialize, serde::Deserialize, Default)]
pub struct DebtorAutogiroView {
    
    #[serde(rename = "AccountNo", skip_serializing_if = "Option::is_none")]
    pub account_no: Option<String>,
    
    #[serde(rename = "Active", skip_serializing_if = "Option::is_none")]
    pub active: Option<bool>,
    
    #[serde(rename = "AutogiroFirstWithdrawalDate", skip_serializing_if = "Option::is_none")]
    pub autogiro_first_withdrawal_date: Option<DateTime>,
    
    #[serde(rename = "ClearingNo", skip_serializing_if = "Option::is_none")]
    pub clearing_no: Option<String>,
    
    #[serde(rename = "PayerNumber", skip_serializing_if = "Option::is_none")]
    pub payer_number: Option<String>,
    
    #[serde(rename = "PaymentServiceSupplier", skip_serializing_if = "Option::is_none")]
    pub payment_service_supplier: Option<String>,
    
}