
use crate::models::ActionSourceTypeView; 
use crate::models::AmountView; 
use crate::models::DateTime; 
use crate::models::DebtCollectionActionEventView; 
use crate::models::DebtCollectionActionInvoiceView; 
use crate::models::DebtCollectionActionLevelTypeView; 
use crate::models::DebtCollectionActionStateView; 
use crate::models::DebtorView; 
use crate::models::DeliveryAddressOverrideView; 
use crate::models::DeliveryMethodTypeView; 
use crate::models::FileView; 
use crate::models::Guid; 
use crate::models::InterestTypeView; 
use crate::models::LanguageTypeView; 

#[derive(Debug, Clone, serde::Serialize, serde::Deserialize, Default)]
pub struct DebtCollectionActionView {
    
    #[serde(rename = "ActionPublicId", skip_serializing_if = "Option::is_none")]
    pub action_public_id: Option<String>,
    
    #[serde(rename = "CanCancel", skip_serializing_if = "Option::is_none")]
    pub can_cancel: Option<bool>,
    
    #[serde(rename = "CanCreateInstallmentPlan", skip_serializing_if = "Option::is_none")]
    pub can_create_installment_plan: Option<bool>,
    
    #[serde(rename = "CanCredit", skip_serializing_if = "Option::is_none")]
    pub can_credit: Option<bool>,
    
    #[serde(rename = "CanDisputeAction", skip_serializing_if = "Option::is_none")]
    pub can_dispute_action: Option<bool>,
    
    #[serde(rename = "CanPostpone", skip_serializing_if = "Option::is_none")]
    pub can_postpone: Option<bool>,
    
    #[serde(rename = "CanSendToBailiff", skip_serializing_if = "Option::is_none")]
    pub can_send_to_bailiff: Option<bool>,
    
    #[serde(rename = "CanSendToBailiffEnforcement", skip_serializing_if = "Option::is_none")]
    pub can_send_to_bailiff_enforcement: Option<bool>,
    
    #[serde(rename = "CanSendToLongTermSurveilance", skip_serializing_if = "Option::is_none")]
    pub can_send_to_long_term_surveilance: Option<bool>,
    
    #[serde(rename = "CommunicationLanguage", skip_serializing_if = "Option::is_none")]
    pub communication_language: Option<LanguageTypeView>,
    
    #[serde(rename = "Created", skip_serializing_if = "Option::is_none")]
    pub created: Option<DateTime>,
    
    #[serde(rename = "CreditorPublicId", skip_serializing_if = "Option::is_none")]
    pub creditor_public_id: Option<Guid>,
    
    #[serde(rename = "CurrentAmount", skip_serializing_if = "Option::is_none")]
    pub current_amount: Option<AmountView>,
    
    #[serde(rename = "DebtAmount", skip_serializing_if = "Option::is_none")]
    pub debt_amount: Option<AmountView>,
    
    #[serde(rename = "DebtCollectionActionSource", skip_serializing_if = "Option::is_none")]
    pub debt_collection_action_source: Option<ActionSourceTypeView>,
    
    #[serde(rename = "Debtor", skip_serializing_if = "Option::is_none")]
    pub debtor: Option<DebtorView>,
    
    #[serde(rename = "DeliveryAddressOverride", skip_serializing_if = "Option::is_none")]
    pub delivery_address_override: Option<DeliveryAddressOverrideView>,
    
    #[serde(rename = "DeliveryMethod", skip_serializing_if = "Option::is_none")]
    pub delivery_method: Option<DeliveryMethodTypeView>,
    
    #[serde(rename = "EndDebtCollectionActionLevel", skip_serializing_if = "Option::is_none")]
    pub end_debt_collection_action_level: Option<DebtCollectionActionLevelTypeView>,
    
    #[serde(rename = "Events", skip_serializing_if = "Vec::is_empty", default)]
    pub events: Vec<DebtCollectionActionEventView>,
    
    #[serde(rename = "FeeAmount", skip_serializing_if = "Option::is_none")]
    pub fee_amount: Option<AmountView>,
    
    #[serde(rename = "InstallmentPlanPublicId", skip_serializing_if = "Option::is_none")]
    pub installment_plan_public_id: Option<String>,
    
    #[serde(rename = "InterestAmount", skip_serializing_if = "Option::is_none")]
    pub interest_amount: Option<AmountView>,
    
    #[serde(rename = "InterestPercentage", skip_serializing_if = "Option::is_none")]
    pub interest_percentage: Option<f64>,
    
    #[serde(rename = "InterestStartInDaysAfterDueDate", skip_serializing_if = "Option::is_none")]
    pub interest_start_in_days_after_due_date: Option<i64>,
    
    #[serde(rename = "InterestType", skip_serializing_if = "Option::is_none")]
    pub interest_type: Option<InterestTypeView>,
    
    #[serde(rename = "InvoiceSourcePublicId", skip_serializing_if = "Option::is_none")]
    pub invoice_source_public_id: Option<String>,
    
    #[serde(rename = "Invoices", skip_serializing_if = "Vec::is_empty", default)]
    pub invoices: Vec<DebtCollectionActionInvoiceView>,
    
    #[serde(rename = "NumberOfReminders", skip_serializing_if = "Option::is_none")]
    pub number_of_reminders: Option<i64>,
    
    #[serde(rename = "OriginalAmount", skip_serializing_if = "Option::is_none")]
    pub original_amount: Option<AmountView>,
    
    #[serde(rename = "OriginalDueDate", skip_serializing_if = "Option::is_none")]
    pub original_due_date: Option<DateTime>,
    
    #[serde(rename = "OriginalInvoiceDate", skip_serializing_if = "Option::is_none")]
    pub original_invoice_date: Option<DateTime>,
    
    #[serde(rename = "OriginalInvoiceFile", skip_serializing_if = "Option::is_none")]
    pub original_invoice_file: Option<FileView>,
    
    #[serde(rename = "OriginalInvoiceNumber", skip_serializing_if = "Option::is_none")]
    pub original_invoice_number: Option<String>,
    
    #[serde(rename = "OurReference", skip_serializing_if = "Option::is_none")]
    pub our_reference: Option<String>,
    
    #[serde(rename = "PaymentTermsInDays", skip_serializing_if = "Option::is_none")]
    pub payment_terms_in_days: Option<i64>,
    
    #[serde(rename = "ReasonDescription", skip_serializing_if = "Option::is_none")]
    pub reason_description: Option<String>,
    
    #[serde(rename = "ReasonForHigherInterest", skip_serializing_if = "Option::is_none")]
    pub reason_for_higher_interest: Option<String>,
    
    #[serde(rename = "StartDebtCollectionActionLevel", skip_serializing_if = "Option::is_none")]
    pub start_debt_collection_action_level: Option<DebtCollectionActionLevelTypeView>,
    
    #[serde(rename = "State", skip_serializing_if = "Option::is_none")]
    pub state: Option<DebtCollectionActionStateView>,
    
    #[serde(rename = "YourReference", skip_serializing_if = "Option::is_none")]
    pub your_reference: Option<String>,
    
}