

#[derive(Debug, Clone, serde::Serialize, serde::Deserialize, Default)]
pub struct CreditorKycFormOwnerView {
    
    #[serde(rename = "Address", skip_serializing_if = "Option::is_none")]
    pub address: Option<String>,
    
    #[serde(rename = "CountryName", skip_serializing_if = "Option::is_none")]
    pub country_name: Option<String>,
    
    #[serde(rename = "HasUsCitizenship", skip_serializing_if = "Option::is_none")]
    pub has_us_citizenship: Option<bool>,
    
    #[serde(rename = "HoldingSharesInPercent", skip_serializing_if = "Option::is_none")]
    pub holding_shares_in_percent: Option<f64>,
    
    #[serde(rename = "HoldingVotesInPercent", skip_serializing_if = "Option::is_none")]
    pub holding_votes_in_percent: Option<f64>,
    
    #[serde(rename = "IsNonLegalEntity", skip_serializing_if = "Option::is_none")]
    pub is_non_legal_entity: Option<bool>,
    
    #[serde(rename = "Name", skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    
    #[serde(rename = "NonLegalEntityIsDirectOWner", skip_serializing_if = "Option::is_none")]
    pub non_legal_entity_is_direct_o_wner: Option<bool>,
    
    #[serde(rename = "SSN", skip_serializing_if = "Option::is_none")]
    pub ssn: Option<String>,
    
}