
use crate::models::CreditorForeignAccountView; 
use crate::models::CreditorOutgoingBankgiroView; 
use crate::models::CreditorPaymentMethodView; 

#[derive(Debug, Clone, serde::Serialize, serde::Deserialize, Default)]
pub struct CreditorBankInfoView {
    
    #[serde(rename = "CreditorOutgoingBankgiroes", skip_serializing_if = "Vec::is_empty", default)]
    pub creditor_outgoing_bankgiroes: Vec<CreditorOutgoingBankgiroView>,
    
    #[serde(rename = "EInvoiceCUI", skip_serializing_if = "Option::is_none")]
    pub e_invoice_cui: Option<String>,
    
    #[serde(rename = "EInvoiceFUI", skip_serializing_if = "Option::is_none")]
    pub e_invoice_fui: Option<String>,
    
    #[serde(rename = "ForeignAccounts", skip_serializing_if = "Vec::is_empty", default)]
    pub foreign_accounts: Vec<CreditorForeignAccountView>,
    
    #[serde(rename = "PaymentMethods", skip_serializing_if = "Vec::is_empty", default)]
    pub payment_methods: Vec<CreditorPaymentMethodView>,
    
    #[serde(rename = "UsesClientFund", skip_serializing_if = "Option::is_none")]
    pub uses_client_fund: Option<bool>,
    
}