
use crate::models::CreditCardAddStatusTypeView; 
use crate::models::DateTime; 
use crate::models::Guid; 
use crate::models::LanguageTypeView; 

#[derive(Debug, Clone, serde::Serialize, serde::Deserialize, Default)]
pub struct CreditCardAddView {
    
    #[serde(rename = "AddWindowUrl", skip_serializing_if = "Option::is_none")]
    pub add_window_url: Option<String>,
    
    #[serde(rename = "Created", skip_serializing_if = "Option::is_none")]
    pub created: Option<DateTime>,
    
    #[serde(rename = "CreditorPublicId", skip_serializing_if = "Option::is_none")]
    pub creditor_public_id: Option<Guid>,
    
    #[serde(rename = "DebtorPublicId", skip_serializing_if = "Option::is_none")]
    pub debtor_public_id: Option<Guid>,
    
    #[serde(rename = "FailureUrl", skip_serializing_if = "Option::is_none")]
    pub failure_url: Option<String>,
    
    #[serde(rename = "Language", skip_serializing_if = "Option::is_none")]
    pub language: Option<LanguageTypeView>,
    
    #[serde(rename = "PublicId", skip_serializing_if = "Option::is_none")]
    pub public_id: Option<Guid>,
    
    #[serde(rename = "Status", skip_serializing_if = "Option::is_none")]
    pub status: Option<CreditCardAddStatusTypeView>,
    
    #[serde(rename = "SuccessUrl", skip_serializing_if = "Option::is_none")]
    pub success_url: Option<String>,
    
}