
use crate::models::AmountView; 
use crate::models::DateTime; 

#[derive(Debug, Clone, serde::Serialize, serde::Deserialize, Default)]
pub struct CreditActionView {
    
    #[serde(rename = "ActionPublicId", skip_serializing_if = "Option::is_none")]
    pub action_public_id: Option<String>,
    
    #[serde(rename = "Comment", skip_serializing_if = "Option::is_none")]
    pub comment: Option<String>,
    
    #[serde(rename = "InvoiceInterest", skip_serializing_if = "Option::is_none")]
    pub invoice_interest: Option<bool>,
    
    #[serde(rename = "IsPaymentCreditation", skip_serializing_if = "Option::is_none")]
    pub is_payment_creditation: Option<bool>,
    
    #[serde(rename = "PaymentDate", skip_serializing_if = "Option::is_none")]
    pub payment_date: Option<DateTime>,
    
    #[serde(rename = "PaymentMeanCode", skip_serializing_if = "Option::is_none")]
    pub payment_mean_code: Option<String>,
    
    #[serde(rename = "Value", skip_serializing_if = "Option::is_none")]
    pub value: Option<AmountView>,
    
}