use std::fmt;


#[derive(Debug, Clone, Copy, serde::Serialize, serde::Deserialize, PartialEq, Eq)]
#[serde(rename_all = "PascalCase")]
#[allow(non_camel_case_types)]
pub enum BankIdStatusTypeView {
    
    Complete,
    Error,
    NoClient,
    OutstandingTransaction,
    Started,
    UserReq,
    UserSign,

}


impl fmt::Display for BankIdStatusTypeView {


    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(f, "{:?}", self)
    }
    
}