
use crate::models::Guid; 

#[derive(Debug, Clone, serde::Serialize, serde::Deserialize, Default)]
pub struct BankIdSignRequestView {
    
    #[serde(rename = "CreditorPublicId", skip_serializing_if = "Option::is_none")]
    pub creditor_public_id: Option<Guid>,
    
    #[serde(rename = "SSN", skip_serializing_if = "Option::is_none")]
    pub ssn: Option<String>,
    
    #[serde(rename = "UserMessage", skip_serializing_if = "Option::is_none")]
    pub user_message: Option<String>,
    
    #[serde(rename = "UserNonVisibleData", skip_serializing_if = "Option::is_none")]
    pub user_non_visible_data: Option<String>,
    
}