use crate::models::{AmountView, DateTime, Guid};

#[derive(Debug, Clone, serde::Serialize, serde::Deserialize)]
#[serde(rename_all = "PascalCase")]
pub struct AnalysisRevenueByProduct {
    pub action_public_id: Guid,
    pub invoice_number: String,
    pub debtor_name: String,
    pub product_public_id: Guid,
    pub product_description: Option<String>,
    pub date: DateTime,
    pub transaction_date: DateTime,
    pub amount: AmountView,

    #[serde(rename = "VAT")]
    pub vat: f64,
    pub quantity: f64,
    pub book_keeping_account: String,
    pub period_start: Option<DateTime>,
    pub period_end: Option<DateTime>,
}