use eiktyrner::{content, HttpClient};
use crate::{Param, PathAndQueryBuilder, Result};

use crate::Client;
use crate::models::{
     CostCenterView,
     CostCentersView,
     CreatedView,
     Guid,
    
};


impl Client {
    
    

/// 
pub async fn cost_centers_create_a_cost_center(&self,body: CostCenterView,
                         
) -> Result<CreatedView> {


    let path_and_query = PathAndQueryBuilder::default()
        .url(Param::value("v1"))
        .url(Param::value("costcenters"))
        .url(Param::value("costcenter"))
        .build();






    let request = self.new_request(
        http::method::Method::POST,
        path_and_query,
    )
    .body(content::Json(body)).expect("setting json body");
    
    self.client.send::<_, content::Json<_>>(request).await
    
}
    
    

/// Imports multiple costCenters. CostCenters will be match on CostCenterNumber for updates or create
pub async fn cost_centers_create_multiple_cost_centers(&self,body: CostCentersView,
                         
) -> Result<CreatedView> {


    let path_and_query = PathAndQueryBuilder::default()
        .url(Param::value("v1"))
        .url(Param::value("costcenters"))
        .url(Param::value("costcenters"))
        .build();






    let request = self.new_request(
        http::method::Method::POST,
        path_and_query,
    )
    .body(content::Json(body)).expect("setting json body");
    
    self.client.send::<_, content::Json<_>>(request).await
    
}
    
    

/// Deletes a cost center. Note that a cost center can't be deleted if it has been used on any invoice. You will get a 400 Bad Request it you try to delete a contract invoice that is used.
/// - **id**: Creditor public id
/// - **code**: Cost center number
pub async fn cost_centers_delete_a_cost_center(&self,id: Guid,
                         code: String,
                         
) -> Result<()> {


    let path_and_query = PathAndQueryBuilder::default()
        .url(Param::value("v1"))
        .url(Param::value("costcenters"))
        .url(Param::value("costcenter"))
        .url(Param::value(id))
        .query("code", Param::value(code))
        .build();






    let request = self.new_request(
        http::method::Method::DELETE,
        path_and_query,
    )
    
    .body(content::Empty).expect("setting json body");
    
    
    self.client.send::<_, content::Empty>(request).await
    
}
    
    

/// 
/// - **id**: Creditor public id
/// - **code**: Cost center code
pub async fn cost_centers_get_a_cost_center(&self,id: Guid,
                         code: String,
                         
) -> Result<CostCenterView> {


    let path_and_query = PathAndQueryBuilder::default()
        .url(Param::value("v1"))
        .url(Param::value("costcenters"))
        .url(Param::value("costcenter"))
        .url(Param::value(id))
        .query("code", Param::value(code))
        .build();






    let request = self.new_request(
        http::method::Method::GET,
        path_and_query,
    )
    
    .body(content::Empty).expect("setting json body");
    
    self.client.send::<_, content::Json<_>>(request).await
    
}
    
    

/// 
/// - **id**: Creditor public id
pub async fn cost_centers_get_all_cost_centers(&self,id: Guid,
                         
) -> Result<CostCentersView> {


    let path_and_query = PathAndQueryBuilder::default()
        .url(Param::value("v1"))
        .url(Param::value("costcenters"))
        .url(Param::value("costcenters"))
        .url(Param::value(id))
        .build();






    let request = self.new_request(
        http::method::Method::GET,
        path_and_query,
    )
    
    .body(content::Empty).expect("setting json body");
    
    self.client.send::<_, content::Json<_>>(request).await
    
}
    
    

/// 
pub async fn cost_centers_update_a_cost_center(&self,body: CreatedView,
                         
) -> Result<()> {


    let path_and_query = PathAndQueryBuilder::default()
        .url(Param::value("v1"))
        .url(Param::value("costcenters"))
        .url(Param::value("costcenter"))
        .build();






    let request = self.new_request(
        http::method::Method::PUT,
        path_and_query,
    )
    .body(content::Json(body)).expect("setting json body");
    
    
    self.client.send::<_, content::Empty>(request).await
    
}
    
}