use crate::{
    models::{AnalysisRevenueByProduct, DateTime, Guid},
    Client, Param, PathAndQueryBuilder, Result,
};
use eiktyrner::{content, HttpClient};

impl Client {
    pub async fn analysis_revenue_by_product(
        &self,
        creditor_id: &Guid,
        invoice_date_from: Option<&DateTime>,
        invoice_date_to: Option<&DateTime>,
    ) -> Result<Vec<AnalysisRevenueByProduct>> {
        let path_and_query = PathAndQueryBuilder::default()
            .url(Param::value("v1"))
            .url(Param::value("analysis"))
            .url(Param::value("revenuebyproduct"))
            .url(Param::value(creditor_id))
            .query("from", Param::opt(invoice_date_from))
            .query("to", Param::opt(invoice_date_to))
            .build();

        let request = self
            .new_request(http::method::Method::GET, path_and_query)
            .body(content::Empty)
            .expect("Building body");

        self.client
            .send::<_, content::Json<Vec<AnalysisRevenueByProduct>>>(request)
            .await
    }
}