use eiktyrner::{content, HttpClient};
use crate::{Param, PathAndQueryBuilder, Result};

use crate::Client;
use crate::models::{
     Base64,
     CommentActionView,
     CommonActionEventsView,
     CreatedView,
     DateTime,
     Guid,
     RegisterSelfInvoiceExternalPaymentView,
     SelfInvoiceActionEntryView,
     SelfInvoiceActionSubsView,
     SelfInvoiceActionView,
     SelfInvoicePaymentView,
    
};


impl Client {
    
    

/// Attesting a self invoice means that is will be book kept and locked for editing. Invoice is automatically sent if any distribution is set.
/// - **id**: Self invoice public id
pub async fn self_invoice_attest_a_self_invoice(&self,id: String,
                         
) -> Result<()> {


    let path_and_query = PathAndQueryBuilder::default()
        .url(Param::value("v1"))
        .url(Param::value("selfinvoice"))
        .url(Param::value("attest"))
        .url(Param::value(id))
        .build();






    let request = self.new_request(
        http::method::Method::PUT,
        path_and_query,
    )
    
    .body(content::Empty).expect("setting json body");
    
    
    self.client.send::<_, content::Empty>(request).await
    
}
    
    

/// Cancels a self invoice and 'reverts' the book keeping.
/// - **id**: Self invoice public id
pub async fn self_invoice_cancel_a_self_invoice(&self,id: String,
                         
) -> Result<()> {


    let path_and_query = PathAndQueryBuilder::default()
        .url(Param::value("v1"))
        .url(Param::value("selfinvoice"))
        .url(Param::value("cancel"))
        .url(Param::value(id))
        .build();






    let request = self.new_request(
        http::method::Method::PUT,
        path_and_query,
    )
    
    .body(content::Empty).expect("setting json body");
    
    
    self.client.send::<_, content::Empty>(request).await
    
}
    
    

/// Writes a comment to the self invoice events log.
pub async fn self_invoice_comment_a_self_invoice(&self,body: CommentActionView,
                         
) -> Result<()> {


    let path_and_query = PathAndQueryBuilder::default()
        .url(Param::value("v1"))
        .url(Param::value("selfinvoice"))
        .url(Param::value("comment"))
        .build();






    let request = self.new_request(
        http::method::Method::POST,
        path_and_query,
    )
    .body(content::Json(body)).expect("setting json body");
    
    
    self.client.send::<_, content::Empty>(request).await
    
}
    
    

/// All created self invoices are saved as drafts. To make it permanent and bookkeep it, the self invoice action must be attested. See the Attest endpoint. BankgiroNo property is one of the approved bankgiro numbers in Creditor.CreditorBankInfo.CreditorOutgoingBankgiroes. Bankgiro numbers are approved by Billecta customer service after a security review.
pub async fn self_invoice_create_a_self_invoice(&self,body: SelfInvoiceActionEntryView,
                         
) -> Result<CreatedView> {


    let path_and_query = PathAndQueryBuilder::default()
        .url(Param::value("v1"))
        .url(Param::value("selfinvoice"))
        .url(Param::value("action"))
        .build();






    let request = self.new_request(
        http::method::Method::POST,
        path_and_query,
    )
    .body(content::Json(body)).expect("setting json body");
    
    self.client.send::<_, content::Json<_>>(request).await
    
}
    
    

/// Only non-attested self invoices can be deleted. Once attested it is locked and deletion is not allowed any more.
/// - **id**: Self invoice public id
pub async fn self_invoice_delete_a_self_invoice(&self,id: String,
                         
) -> Result<()> {


    let path_and_query = PathAndQueryBuilder::default()
        .url(Param::value("v1"))
        .url(Param::value("selfinvoice"))
        .url(Param::value("action"))
        .url(Param::value(id))
        .build();






    let request = self.new_request(
        http::method::Method::DELETE,
        path_and_query,
    )
    
    .body(content::Empty).expect("setting json body");
    
    
    self.client.send::<_, content::Empty>(request).await
    
}
    
    

/// Returns a self invoice based on the ActionPublicId. All self invoices have a unique ActionPublicId that is generated on creation.
/// - **id**: Self invoice public id
pub async fn self_invoice_get_a_self_invoice(&self,id: String,
                         
) -> Result<SelfInvoiceActionView> {


    let path_and_query = PathAndQueryBuilder::default()
        .url(Param::value("v1"))
        .url(Param::value("selfinvoice"))
        .url(Param::value("action"))
        .url(Param::value(id))
        .build();






    let request = self.new_request(
        http::method::Method::GET,
        path_and_query,
    )
    
    .body(content::Empty).expect("setting json body");
    
    self.client.send::<_, content::Json<_>>(request).await
    
}
    
    

/// Retrieves all self invoices that have a closed/full payment date between the specified from and to dates
/// - **id**: Creditor public id
/// - **from**: From date
/// - **to**: To date
/// - **offset**: Offset
/// - **limit**: Limit
/// - **sortingfield**: Sorting field
/// - **asc**: Ascending sorting. Default value is true
pub async fn self_invoice_get_all_closed_self_invoices(&self,id: Guid,
                         from: DateTime,
                         to: DateTime,
                         offset: Option<i64>,
                         limit: Option<i64>,
                         sortingfield: Option<String>,
                         asc: Option<bool>,
                         
) -> Result<SelfInvoiceActionSubsView> {


    let path_and_query = PathAndQueryBuilder::default()
        .url(Param::value("v1"))
        .url(Param::value("selfinvoice"))
        .url(Param::value("closed"))
        .url(Param::value(id))
        .query("from", Param::value(from))
        .query("to", Param::value(to))
        .query("offset", Param::opt(offset))
        .query("limit", Param::opt(limit))
        .query("sortingfield", Param::opt(sortingfield))
        .query("asc", Param::opt(asc))
        .build();






    let request = self.new_request(
        http::method::Method::GET,
        path_and_query,
    )
    
    .body(content::Empty).expect("setting json body");
    
    self.client.send::<_, content::Json<_>>(request).await
    
}
    
    

/// 
/// - **id**: Creditor public id
/// - **from**: From date
/// - **to**: To date
pub async fn self_invoice_get_all_events_for_all_self_invoices(&self,id: Guid,
                         from: DateTime,
                         to: DateTime,
                         
) -> Result<CommonActionEventsView> {


    let path_and_query = PathAndQueryBuilder::default()
        .url(Param::value("v1"))
        .url(Param::value("selfinvoice"))
        .url(Param::value("events"))
        .url(Param::value(id))
        .query("from", Param::value(from))
        .query("to", Param::value(to))
        .build();






    let request = self.new_request(
        http::method::Method::GET,
        path_and_query,
    )
    
    .body(content::Empty).expect("setting json body");
    
    self.client.send::<_, content::Json<_>>(request).await
    
}
    
    

/// Retrieves all drafts/attested and unpaid self invoices.
/// - **id**: Creditor public id
/// - **offset**: Offset
/// - **limit**: Limit
/// - **sortingfield**: Sorting field
/// - **asc**: Ascending sorting. Default value is true
pub async fn self_invoice_get_all_open_self_invoices(&self,id: Guid,
                         offset: Option<i64>,
                         limit: Option<i64>,
                         sortingfield: Option<String>,
                         asc: Option<bool>,
                         
) -> Result<SelfInvoiceActionSubsView> {


    let path_and_query = PathAndQueryBuilder::default()
        .url(Param::value("v1"))
        .url(Param::value("selfinvoice"))
        .url(Param::value("open"))
        .url(Param::value(id))
        .query("offset", Param::opt(offset))
        .query("limit", Param::opt(limit))
        .query("sortingfield", Param::opt(sortingfield))
        .query("asc", Param::opt(asc))
        .build();






    let request = self.new_request(
        http::method::Method::GET,
        path_and_query,
    )
    
    .body(content::Empty).expect("setting json body");
    
    self.client.send::<_, content::Json<_>>(request).await
    
}
    
    

/// Pauses the self invoice from any more automatic events.
/// - **id**: Self invoice public id
pub async fn self_invoice_pause_a_self_invoice(&self,id: String,
                         
) -> Result<()> {


    let path_and_query = PathAndQueryBuilder::default()
        .url(Param::value("v1"))
        .url(Param::value("selfinvoice"))
        .url(Param::value("pause"))
        .url(Param::value(id))
        .build();






    let request = self.new_request(
        http::method::Method::PUT,
        path_and_query,
    )
    
    .body(content::Empty).expect("setting json body");
    
    
    self.client.send::<_, content::Empty>(request).await
    
}
    
    

/// Preview a self invoice to view how it will be generated. This endpoint previews data already stored in API/database. This endpoint returns a PDF data stream in the content
/// - **id**: Self invoice public id
pub async fn self_invoice_preview_a_self_invoice_by_id(&self,id: String,
                         
) -> Result<Base64> {


    let path_and_query = PathAndQueryBuilder::default()
        .url(Param::value("v1"))
        .url(Param::value("selfinvoice"))
        .url(Param::value("preview"))
        .url(Param::value(id))
        .build();






    let request = self.new_request(
        http::method::Method::GET,
        path_and_query,
    )
    
    .body(content::Empty).expect("setting json body");
    
    self.client.send::<_, content::Json<_>>(request).await
    
}
    
    

/// Preview a self invoice to view how it will be generated. This endpoint previews data sent in the request and ignores data stored in the API/database. This endpoint returns a PDF data stream in the content
pub async fn self_invoice_preview_a_self_invoice(&self,body: SelfInvoiceActionEntryView,
                         
) -> Result<Base64> {


    let path_and_query = PathAndQueryBuilder::default()
        .url(Param::value("v1"))
        .url(Param::value("selfinvoice"))
        .url(Param::value("preview"))
        .build();






    let request = self.new_request(
        http::method::Method::POST,
        path_and_query,
    )
    .body(content::Json(body)).expect("setting json body");
    
    self.client.send::<_, content::Json<_>>(request).await
    
}
    
    

/// Register an already made payment on the self invoice (externally and not made through Billecta). Calling this endpoint lowers the remaining value on the invoice and does not trigger any payment.
pub async fn self_invoice_register_payment_on_a_self_invoice_made_outside_billecta(&self,body: RegisterSelfInvoiceExternalPaymentView,
                         
) -> Result<CreatedView> {


    let path_and_query = PathAndQueryBuilder::default()
        .url(Param::value("v1"))
        .url(Param::value("selfinvoice"))
        .url(Param::value("registerexternalpayment"))
        .build();






    let request = self.new_request(
        http::method::Method::POST,
        path_and_query,
    )
    .body(content::Json(body)).expect("setting json body");
    
    self.client.send::<_, content::Json<_>>(request).await
    
}
    
    

/// Resumes the self invoice to automatically process events.
/// - **id**: Self invoice public id
pub async fn self_invoice_resume_a_self_invoice(&self,id: String,
                         
) -> Result<()> {


    let path_and_query = PathAndQueryBuilder::default()
        .url(Param::value("v1"))
        .url(Param::value("selfinvoice"))
        .url(Param::value("resume"))
        .url(Param::value(id))
        .build();






    let request = self.new_request(
        http::method::Method::PUT,
        path_and_query,
    )
    
    .body(content::Empty).expect("setting json body");
    
    
    self.client.send::<_, content::Empty>(request).await
    
}
    
    

/// Sends the invoice by email
/// - **id**: Self invoice public id
pub async fn self_invoice_send_invoice_for_a_self_invoice(&self,id: String,
                         
) -> Result<()> {


    let path_and_query = PathAndQueryBuilder::default()
        .url(Param::value("v1"))
        .url(Param::value("selfinvoice"))
        .url(Param::value("sendinvoice"))
        .url(Param::value(id))
        .build();






    let request = self.new_request(
        http::method::Method::PUT,
        path_and_query,
    )
    
    .body(content::Empty).expect("setting json body");
    
    
    self.client.send::<_, content::Empty>(request).await
    
}
    
    

/// Triggers a payment from specified bankgiro number on the self invoice. Amount and date is set in the request.
pub async fn self_invoice_send_payment_for_a_self_invoice(&self,body: SelfInvoicePaymentView,
                         
) -> Result<()> {


    let path_and_query = PathAndQueryBuilder::default()
        .url(Param::value("v1"))
        .url(Param::value("selfinvoice"))
        .url(Param::value("sendpayment"))
        .build();






    let request = self.new_request(
        http::method::Method::PUT,
        path_and_query,
    )
    .body(content::Json(body)).expect("setting json body");
    
    
    self.client.send::<_, content::Empty>(request).await
    
}
    
    

/// Note that only non-attested self invoices can be updated. Once attested it is locked and update is not possible any more.
/// - **id**: Self invoice public id
pub async fn self_invoice_update_a_self_invoice(&self,id: String,
                         body: SelfInvoiceActionEntryView,
                         
) -> Result<()> {


    let path_and_query = PathAndQueryBuilder::default()
        .url(Param::value("v1"))
        .url(Param::value("selfinvoice"))
        .url(Param::value("action"))
        .url(Param::value(id))
        .build();






    let request = self.new_request(
        http::method::Method::PUT,
        path_and_query,
    )
    .body(content::Json(body)).expect("setting json body");
    
    
    self.client.send::<_, content::Empty>(request).await
    
}
    
}