
use crate::models::IntermediatorTypeView; 

#[derive(Debug, Clone, serde::Serialize, serde::Deserialize, Default)]
pub struct UpdateAddressActionView {
    
    #[serde(rename = "ActionPublicId", skip_serializing_if = "Option::is_none")]
    pub action_public_id: Option<String>,
    
    #[serde(rename = "Address", skip_serializing_if = "Option::is_none")]
    pub address: Option<String>,
    
    #[serde(rename = "Address2", skip_serializing_if = "Option::is_none")]
    pub address2: Option<String>,
    
    #[serde(rename = "Attention", skip_serializing_if = "Option::is_none")]
    pub attention: Option<String>,
    
    #[serde(rename = "CareOf", skip_serializing_if = "Option::is_none")]
    pub care_of: Option<String>,
    
    #[serde(rename = "City", skip_serializing_if = "Option::is_none")]
    pub city: Option<String>,
    
    #[serde(rename = "Email", skip_serializing_if = "Option::is_none")]
    pub email: Option<String>,
    
    #[serde(rename = "GLN", skip_serializing_if = "Option::is_none")]
    pub gln: Option<String>,
    
    #[serde(rename = "Intermediator", skip_serializing_if = "Option::is_none")]
    pub intermediator: Option<IntermediatorTypeView>,
    
    #[serde(rename = "Name", skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    
    #[serde(rename = "OrgNo", skip_serializing_if = "Option::is_none")]
    pub org_no: Option<String>,
    
    #[serde(rename = "Phone", skip_serializing_if = "Option::is_none")]
    pub phone: Option<String>,
    
    #[serde(rename = "ZipCode", skip_serializing_if = "Option::is_none")]
    pub zip_code: Option<String>,
    
}