
use crate::models::AmountView; 
use crate::models::DateTime; 

#[derive(Debug, Clone, serde::Serialize, serde::Deserialize, Default)]
pub struct SelfInvoicePaymentView {
    
    #[serde(rename = "ActionPublicId", skip_serializing_if = "Option::is_none")]
    pub action_public_id: Option<String>,
    
    #[serde(rename = "Amount", skip_serializing_if = "Option::is_none")]
    pub amount: Option<AmountView>,
    
    #[serde(rename = "PaymentDate", skip_serializing_if = "Option::is_none")]
    pub payment_date: Option<DateTime>,
    
}