
use crate::models::DateTime; 
use crate::models::DeliveryMethodTypeView; 
use crate::models::Guid; 
use crate::models::LanguageTypeView; 
use crate::models::ReferenceTypeView; 
use crate::models::SelfInvoiceActionAttachmentView; 
use crate::models::SelfInvoiceActionRecordView; 

#[derive(Debug, Clone, serde::Serialize, serde::Deserialize, Default)]
pub struct SelfInvoiceActionEntryView {
    
    #[serde(rename = "Attachments", skip_serializing_if = "Vec::is_empty", default)]
    pub attachments: Vec<SelfInvoiceActionAttachmentView>,
    
    #[serde(rename = "BankgiroNo", skip_serializing_if = "Option::is_none")]
    pub bankgiro_no: Option<String>,
    
    #[serde(rename = "CommunicationLanguage", skip_serializing_if = "Option::is_none")]
    pub communication_language: Option<LanguageTypeView>,
    
    #[serde(rename = "CreditingSelfInvoicePublicId", skip_serializing_if = "Option::is_none")]
    pub crediting_self_invoice_public_id: Option<String>,
    
    #[serde(rename = "CreditorPublicId", skip_serializing_if = "Option::is_none")]
    pub creditor_public_id: Option<Guid>,
    
    #[serde(rename = "DebtorPublicId", skip_serializing_if = "Option::is_none")]
    pub debtor_public_id: Option<Guid>,
    
    #[serde(rename = "DeliveryDate", skip_serializing_if = "Option::is_none")]
    pub delivery_date: Option<DateTime>,
    
    #[serde(rename = "DeliveryMethod", skip_serializing_if = "Option::is_none")]
    pub delivery_method: Option<DeliveryMethodTypeView>,
    
    #[serde(rename = "DueDate", skip_serializing_if = "Option::is_none")]
    pub due_date: Option<DateTime>,
    
    #[serde(rename = "InvoiceDate", skip_serializing_if = "Option::is_none")]
    pub invoice_date: Option<DateTime>,
    
    #[serde(rename = "Message", skip_serializing_if = "Option::is_none")]
    pub message: Option<String>,
    
    #[serde(rename = "OurReference", skip_serializing_if = "Option::is_none")]
    pub our_reference: Option<String>,
    
    #[serde(rename = "Records", skip_serializing_if = "Vec::is_empty", default)]
    pub records: Vec<SelfInvoiceActionRecordView>,
    
    #[serde(rename = "TransferReference", skip_serializing_if = "Option::is_none")]
    pub transfer_reference: Option<String>,
    
    #[serde(rename = "TransferReferenceType", skip_serializing_if = "Option::is_none")]
    pub transfer_reference_type: Option<ReferenceTypeView>,
    
    #[serde(rename = "YourReference", skip_serializing_if = "Option::is_none")]
    pub your_reference: Option<String>,
    
}