
use crate::models::AmountView; 

#[derive(Debug, Clone, serde::Serialize, serde::Deserialize, Default)]
pub struct RotRutCustomerView {
    
    #[serde(rename = "AskedAmount", skip_serializing_if = "Option::is_none")]
    pub asked_amount: Option<AmountView>,
    
    #[serde(rename = "Name", skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    
    #[serde(rename = "SSN", skip_serializing_if = "Option::is_none")]
    pub ssn: Option<String>,
    
}