
use crate::models::AmountView; 
use crate::models::DateTime; 
use crate::models::InvoiceActionStageTypeView; 
use crate::models::ReminderInvoiceActionInvoiceView; 

#[derive(Debug, Clone, serde::Serialize, serde::Deserialize, Default)]
pub struct ReminderInvoiceActionView {
    
    #[serde(rename = "ActionPublicId", skip_serializing_if = "Option::is_none")]
    pub action_public_id: Option<String>,
    
    #[serde(rename = "ClosedDate", skip_serializing_if = "Option::is_none")]
    pub closed_date: Option<DateTime>,
    
    #[serde(rename = "Created", skip_serializing_if = "Option::is_none")]
    pub created: Option<DateTime>,
    
    #[serde(rename = "CurrentValue", skip_serializing_if = "Option::is_none")]
    pub current_value: Option<AmountView>,
    
    #[serde(rename = "ReminderFee", skip_serializing_if = "Option::is_none")]
    pub reminder_fee: Option<AmountView>,
    
    #[serde(rename = "ReminderInvoices", skip_serializing_if = "Vec::is_empty", default)]
    pub reminder_invoices: Vec<ReminderInvoiceActionInvoiceView>,
    
    #[serde(rename = "SourceActionPublicId", skip_serializing_if = "Option::is_none")]
    pub source_action_public_id: Option<String>,
    
    #[serde(rename = "Stage", skip_serializing_if = "Option::is_none")]
    pub stage: Option<InvoiceActionStageTypeView>,
    
}