
use crate::models::DateTime; 
use crate::models::MonthlyRecurrenceView; 
use crate::models::QuarterlyRecurrenceView; 
use crate::models::RecurrenceIntervalTypeView; 
use crate::models::YearlyRecurrenceView; 

#[derive(Debug, Clone, serde::Serialize, serde::Deserialize, Default)]
pub struct RecurrenceDetailsView {
    
    #[serde(rename = "End", skip_serializing_if = "Option::is_none")]
    pub end: Option<DateTime>,
    
    #[serde(rename = "MonthlyRecurrence", skip_serializing_if = "Option::is_none")]
    pub monthly_recurrence: Option<MonthlyRecurrenceView>,
    
    #[serde(rename = "NoEndDate", skip_serializing_if = "Option::is_none")]
    pub no_end_date: Option<bool>,
    
    #[serde(rename = "QuarterlyRecurrence", skip_serializing_if = "Option::is_none")]
    pub quarterly_recurrence: Option<QuarterlyRecurrenceView>,
    
    #[serde(rename = "RecurrenceInterval", skip_serializing_if = "Option::is_none")]
    pub recurrence_interval: Option<RecurrenceIntervalTypeView>,
    
    #[serde(rename = "Start", skip_serializing_if = "Option::is_none")]
    pub start: Option<DateTime>,
    
    #[serde(rename = "YearlyRecurrence", skip_serializing_if = "Option::is_none")]
    pub yearly_recurrence: Option<YearlyRecurrenceView>,
    
}