
use crate::models::ActionTypeView; 
use crate::models::AmountView; 
use crate::models::DateTime; 
use crate::models::DeliveryMethodTypeView; 
use crate::models::FileView; 
use crate::models::Guid; 
use crate::models::ReconciliationInvoiceActionStageTypeView; 

#[derive(Debug, Clone, serde::Serialize, serde::Deserialize, Default)]
pub struct ReconciliationInvoiceActionSubView {
    
    #[serde(rename = "ActionPublicId", skip_serializing_if = "Option::is_none")]
    pub action_public_id: Option<String>,
    
    #[serde(rename = "ActionType", skip_serializing_if = "Option::is_none")]
    pub action_type: Option<ActionTypeView>,
    
    #[serde(rename = "ClosedDate", skip_serializing_if = "Option::is_none")]
    pub closed_date: Option<DateTime>,
    
    #[serde(rename = "Created", skip_serializing_if = "Option::is_none")]
    pub created: Option<DateTime>,
    
    #[serde(rename = "CreditorName", skip_serializing_if = "Option::is_none")]
    pub creditor_name: Option<String>,
    
    #[serde(rename = "CreditorOrgNo", skip_serializing_if = "Option::is_none")]
    pub creditor_org_no: Option<String>,
    
    #[serde(rename = "CreditorPublicId", skip_serializing_if = "Option::is_none")]
    pub creditor_public_id: Option<Guid>,
    
    #[serde(rename = "CurrentAmount", skip_serializing_if = "Option::is_none")]
    pub current_amount: Option<AmountView>,
    
    #[serde(rename = "DebtCollectionActionPublicId", skip_serializing_if = "Option::is_none")]
    pub debt_collection_action_public_id: Option<String>,
    
    #[serde(rename = "DebtorDebtorNo", skip_serializing_if = "Option::is_none")]
    pub debtor_debtor_no: Option<String>,
    
    #[serde(rename = "DebtorEmail", skip_serializing_if = "Option::is_none")]
    pub debtor_email: Option<String>,
    
    #[serde(rename = "DebtorName", skip_serializing_if = "Option::is_none")]
    pub debtor_name: Option<String>,
    
    #[serde(rename = "DebtorOrgNo", skip_serializing_if = "Option::is_none")]
    pub debtor_org_no: Option<String>,
    
    #[serde(rename = "DebtorPhone", skip_serializing_if = "Option::is_none")]
    pub debtor_phone: Option<String>,
    
    #[serde(rename = "DeliveryMethod", skip_serializing_if = "Option::is_none")]
    pub delivery_method: Option<DeliveryMethodTypeView>,
    
    #[serde(rename = "InvoiceFile", skip_serializing_if = "Option::is_none")]
    pub invoice_file: Option<FileView>,
    
    #[serde(rename = "InvoiceNumber", skip_serializing_if = "Option::is_none")]
    pub invoice_number: Option<String>,
    
    #[serde(rename = "InvoiceSentDate", skip_serializing_if = "Option::is_none")]
    pub invoice_sent_date: Option<DateTime>,
    
    #[serde(rename = "InvoicedAmount", skip_serializing_if = "Option::is_none")]
    pub invoiced_amount: Option<AmountView>,
    
    #[serde(rename = "OCR", skip_serializing_if = "Option::is_none")]
    pub ocr: Option<String>,
    
    #[serde(rename = "ReminderInvoiceSentDate", skip_serializing_if = "Option::is_none")]
    pub reminder_invoice_sent_date: Option<DateTime>,
    
    #[serde(rename = "Stage", skip_serializing_if = "Option::is_none")]
    pub stage: Option<ReconciliationInvoiceActionStageTypeView>,
    
}