
use crate::models::DateTime; 
use crate::models::Guid; 
use crate::models::ReconciliationInvoiceActionStageTypeView; 

#[derive(Debug, Clone, serde::Serialize, serde::Deserialize, Default)]
pub struct ReconciliationInvoiceActionStateView {
    
    #[serde(rename = "ClosedDate", skip_serializing_if = "Option::is_none")]
    pub closed_date: Option<DateTime>,
    
    #[serde(rename = "CreditCardPaymentPublicId", skip_serializing_if = "Option::is_none")]
    pub credit_card_payment_public_id: Option<Guid>,
    
    #[serde(rename = "InvoiceSentDate", skip_serializing_if = "Option::is_none")]
    pub invoice_sent_date: Option<DateTime>,
    
    #[serde(rename = "InvoiceWasIncludedInEmail", skip_serializing_if = "Option::is_none")]
    pub invoice_was_included_in_email: Option<bool>,
    
    #[serde(rename = "IsPayed", skip_serializing_if = "Option::is_none")]
    pub is_payed: Option<bool>,
    
    #[serde(rename = "Stage", skip_serializing_if = "Option::is_none")]
    pub stage: Option<ReconciliationInvoiceActionStageTypeView>,
    
    #[serde(rename = "SwishPaymentPublicId", skip_serializing_if = "Option::is_none")]
    pub swish_payment_public_id: Option<String>,
    
}