use std::fmt;


#[derive(Debug, Clone, Copy, serde::Serialize, serde::Deserialize, PartialEq, Eq)]
#[serde(rename_all = "PascalCase")]
#[allow(non_camel_case_types)]
pub enum ReconciliationInvoiceActionStageTypeView {
    
    Completed,
    Created,
    InvoiceSent,
    None,
    SentToDebtCollection,

}


impl fmt::Display for ReconciliationInvoiceActionStageTypeView {


    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(f, "{:?}", self)
    }
    
}