use std::fmt;


#[derive(Debug, Clone, Copy, serde::Serialize, serde::Deserialize, PartialEq, Eq)]
#[serde(rename_all = "PascalCase")]
#[allow(non_camel_case_types)]
pub enum InvoiceActionStageTypeView {
    
    Attested,
    Cancelled,
    Completed,
    Created,
    InvoiceSent,
    Manual,
    None,
    ReminderInvoiceSent,
    SaleRequestAccepted,
    SalesRequested,
    SalesRequestedCancelled,
    SalesRequestedDenied,
    SentToDebtCollection,

}


impl fmt::Display for InvoiceActionStageTypeView {


    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(f, "{:?}", self)
    }
    
}