use std::fmt;


#[derive(Debug, Clone, Copy, serde::Serialize, serde::Deserialize, PartialEq, Eq)]
#[serde(rename_all = "PascalCase")]
#[allow(non_camel_case_types)]
pub enum IntermediatorTypeView {
    
    AKSESSPUNKT,
    APIX,
    BASWARE,
    COMPELLO,
    CREDIFLOW,
    DABASESS,
    EDB,
    ESSESESS,
    EXPERT,
    HANDSESS,
    HUSERA,
    INEXCHANGE,
    ITELLA,
    LIAISON_FI,
    LOGICA,
    LOGIQ,
    NDEASESS,
    PAGERO,
    PEPPOL,
    PROCEEDO,
    SCANCLOUD,
    STRALFORS1,
    SWEDSESS,
    TIETOSE,

}


impl fmt::Display for IntermediatorTypeView {


    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(f, "{:?}", self)
    }
    
}