use std::fmt;


#[derive(Debug, Clone, Copy, serde::Serialize, serde::Deserialize, PartialEq, Eq)]
#[serde(rename_all = "PascalCase")]
#[allow(non_camel_case_types)]
pub enum InstallmentPlanActionStageTypeView {
    
    Attested,
    AwaitingFeePayment,
    Cancelled,
    Completed,
    Created,
    InstallmentPlanInvoiceSent,
    Manual,
    None,
    ReturnToSourceRequested,

}


impl fmt::Display for InstallmentPlanActionStageTypeView {


    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(f, "{:?}", self)
    }
    
}